/*
 *  hxen_load.h
 *  hxen
 *
 *  Copyright 2009 Citrix Systems, Inc. All rights reserved.
 *
 */

#ifndef _KXEN_LOAD_H_
#define _KXEN_LOAD_H_

struct code {
    unsigned long c_len;
    uint8_t c_code[];
};

struct os_code {
    char name[32];
    const struct code *code;
};

struct os_code_fixup {
    unsigned long start;
    unsigned long end;
};

#define NOP_BYTE 0x90

static int
hxen_fixup_os_code(struct elf_binary *elf, uint8_t *hv, const char *os)
{
    struct os_code *os_code;
    const struct os_code_fixup *fixup;
    char match[32];
    int match_len;
    const elf_shdr *shdr;
    const char *sname;
    int count, i, code_index;
    int fixups = 0;
    int ret = -1;

    count = elf_shdr_count(elf);
    os_code = kernel_malloc(count * sizeof(struct os_code));
    if (os_code == NULL)
	return -1;
    memset((void *)os_code, 0, count * sizeof(struct os_code));

    match_len = snprintf(match, sizeof(match), ".os_code.%s", os);
    if (match_len >= sizeof(match))
	goto out;

    for (i = 0; i < count; i++) {
	shdr = elf_shdr_by_index(elf, i);
	sname = elf_section_name(elf, shdr);
	if (!strncmp(sname, match, match_len)) {
	    if (strlen(sname + match_len + 1) > sizeof(os_code[i].name))
		goto out;
	    strncpy(os_code[i].name, sname + match_len + 1,
		    strlen(sname + match_len + 1));
	    os_code[i].code = elf_section_start(elf, shdr);
	    dprintk("got code for %s in section %s, len %d\n",
		    sname + match_len + 1, sname,
		    os_code[i].code->c_len);
	}
    }
    match_len = snprintf(match, sizeof(match), ".os_code_addr");
    if (match_len >= sizeof(match))
	goto out;
    for (i = 0; i < count; i++) {
	shdr = elf_shdr_by_index(elf, i);
	sname = elf_section_name(elf, shdr);
	if (!strncmp(sname, match, match_len)) {
	    for (code_index = 0; code_index < count; code_index++)
		if (os_code[code_index].name[0] &&
		    strncmp(sname + match_len + 1, os_code[code_index].name,
			    strlen(os_code[code_index].name)) == 0)
		    break;
	    if (code_index == count)
		goto out;
	    fixup = (struct os_code_fixup *)elf_section_start(elf, shdr);
	    while ((void *)fixup < (void *)elf_section_end(elf, shdr)) {
		if (os_code[code_index].code->c_len >
		    (fixup->end - fixup->start))
		    goto out;
		memset(&hv[fixup->start], NOP_BYTE, fixup->end - fixup->start);
		memcpy(&hv[fixup->start], os_code[code_index].code->c_code,
		       os_code[code_index].code->c_len);
		fixup++;
		fixups++;
	    }
	}
    }
    dprintk("hxen: fixed up %d host cpu number code sequences\n", fixups);
    ret = 0;
  out:
    kernel_free(os_code, count * sizeof(struct os_code));
    return ret;
}

#endif
