#ifndef __LIBELF_PRIVATE_H__
#define __LIBELF_PRIVATE_H_

#if defined(WINNT)
#ifdef __KERNEL__
#include <minidrv.h>
#define printk hxen_printk
extern int hxen_printk(const char *, ...);
#else
#include <windows.h>
#include <winnt.h>
#include <stdlib.h>
#include <stdio.h>
#define printk printf
#include <bswap.h>
#endif
#include <xen/types.h>
#include <public/elfnote.h>
#include <public/libelf.h>

#define elf_msg(elf, fmt, ... ) \
   if (elf->verbose) printk(fmt, __VA_ARGS__ )
#define elf_err(elf, fmt, ... ) \
   printk(fmt, __VA_ARGS__ )

# if BITS_PER_LONG == 64
#  define __PRI64_PREFIX        "l"
#  define __PRIPTR_PREFIX       "l"
# else
#  define __PRI64_PREFIX        "I64"
#  define __PRIPTR_PREFIX
# endif

#ifndef PRIx32
#define PRIx32 "x"
#endif
#ifndef PRId64
#define PRId64 __PRI64_PREFIX "d"
#endif
#ifndef PRIu64
#define PRIu64 __PRI64_PREFIX "u"
#endif
#ifndef PRIx64
#define PRIx64 __PRI64_PREFIX "x"
#endif

#ifndef bswap_16
#define bswap_16(x) _byteswap_ushort(x)
#endif
#ifndef bswap_32
#define bswap_32(x) _byteswap_ulong(x)
#endif
#ifndef bswap_64
#define bswap_64(x) _byteswap_uint64(x)
#endif

#elif defined(__APPLE__) && defined(KERNEL)

#include <libkern/libkern.h>
#include <sys/conf.h>
#include <sys/errno.h>
#include <mach/mach_types.h>

#include <public/elfnote.h>
#include <public/libelf.h>

#ifdef elf_printk
void elf_printk(const char *, ...);
#else
#define elf_printk(fmt, ...) do { } while(0)
#endif

#define elf_msg(elf, fmt, args ... ) \
   if (elf->verbose) elf_printk(fmt, ## args )
#define elf_err(elf, fmt, args ... ) \
   elf_printk(fmt, ## args )

#ifndef PRIx32
#define PRIx32 "x"
#endif
#ifndef PRIx64
#define PRIx64 "qx"
#endif

#define typeof(x) __typeof__(x)

/* AABB => BBAA */
static inline uint16_t bswap_16(uint16_t _x) {
    uint16_t _ff = 0xff;
    return ((_x >> 8) | ((_x << 8) & (_ff << 8)));
}
/* AABBCCDD => DDCCBBAA */
static inline uint32_t bswap_32(uint32_t _x) {
    uint32_t _ff = 0xff;
    return ((_x >> 24) | ((_x >> 8) & (_ff << 8)) |
            ((_x << 8) & (_ff << 16)) | ((_x << 24) & (_ff << 24)));
}
/* AABBCCDDEEFFGGHH => HHGGFFEEDDCCBBAA */
static inline uint64_t bswap_64(uint64_t _x) {
    uint64_t _ff = 0xff;
    return ((_x >> 56) | ((_x >> 40) & (_ff << 8)) |
            ((_x >> 24) & (_ff << 16)) | ((_x >> 8) & (_ff << 24)) |
                 ((_x << 8) & (_ff << 32)) | ((_x << 24) & (_ff << 40)) |
                 ((_x << 40) & (_ff << 48)) | ((_x << 56) & (_ff << 56)));
}

#else  /* !WINNT && (!__APPLE__ && !KERNEL) */
#ifdef __KERNEL__
#define __XEN__

#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/string.h>
#include <asm/byteorder.h>
#include <public/elfnote.h>
#include <public/libelf.h>

#define elf_msg(elf, fmt, args ... ) \
   if (elf->verbose) printk(fmt, ## args )
#define elf_err(elf, fmt, args ... ) \
   printk(fmt, ## args )

# if BITS_PER_LONG == 64
#  define __PRI64_PREFIX        "l"
#  define __PRIPTR_PREFIX       "l"
# else
#  define __PRI64_PREFIX        "ll"
#  define __PRIPTR_PREFIX
# endif
#define PRIx32 "x"
#define PRId64 __PRI64_PREFIX "d"
#define PRIu64 __PRI64_PREFIX "u"
#define PRIx64 __PRI64_PREFIX "x"

#define bswap_16(x) swab16(x)
#define bswap_32(x) swab32(x)
#define bswap_64(x) swab64(x)
#else
#ifdef __XEN__

#include <xen/config.h>
#include <xen/types.h>
#include <xen/string.h>
#include <xen/lib.h>
#include <asm/byteorder.h>
#include <public/elfnote.h>
#include <public/libelf.h>

#define elf_msg(elf, fmt, args ... ) \
   if (elf->verbose) printk(fmt, ## args )
#define elf_err(elf, fmt, args ... ) \
   printk(fmt, ## args )

#define strtoull(str, end, base) simple_strtoull(str, end, base)
#define bswap_16(x) swab16(x)
#define bswap_32(x) swab32(x)
#define bswap_64(x) swab64(x)

#else /* !__XEN__ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stddef.h>
#include <inttypes.h>
#ifdef __sun__
#include <sys/byteorder.h>
#define bswap_16(x) BSWAP_16(x)
#define bswap_32(x) BSWAP_32(x)
#define bswap_64(x) BSWAP_64(x)
#elif defined(__NetBSD__)
#include <sys/bswap.h>
#define bswap_16(x) bswap16(x)
#define bswap_32(x) bswap32(x)
#define bswap_64(x) bswap64(x)
#elif defined(__OpenBSD__)
#include <machine/endian.h>
#define bswap_16(x) swap16(x)
#define bswap_32(x) swap32(x)
#define bswap_64(x) swap64(x)
#elif defined(__linux__) || defined(__Linux__) || defined(__MINIOS__)
#include <byteswap.h>
#elif defined(__APPLE__)
#include <bswap.h>
#else
#error Unsupported OS
#endif
#if 0
#include <xen/elfnote.h>
#include <xen/libelf.h>

#include "xenctrl.h"
#include "xc_private.h"
#else
#include <public/elfnote.h>
#include <public/libelf.h>
#define xc_set_error(err ...)

#endif

#define elf_msg(elf, fmt, args ... ) \
    if (elf->log && elf->verbose) fprintf(elf->log, fmt , ## args )
#define elf_err(elf, fmt, args ... ) do {               \
    if (elf->log)                                       \
        fprintf(elf->log, fmt , ## args );              \
    xc_set_error(XC_INVALID_KERNEL, fmt , ## args );    \
} while (0)

#define safe_strcpy(d,s)                        \
do { strncpy((d),(s),sizeof((d))-1);            \
     (d)[sizeof((d))-1] = '\0';                 \
} while (0)

#endif
#endif
#endif

#define elfdest_memcpy(elf, dest, src, n) do {						\
    elf->memcpy ? elf->memcpy(dest, src, n) : memcpy(dest, src, n);	\
} while(0)

#define elfdest_memset(elf, s, c, n) do {					\
    elf->memset ? elf->memset(s, c, n) : memset(s, c, n);	\
} while(0)

#endif /* __LIBELF_PRIVATE_H_ */

/*
 * Local variables:
 * mode: C
 * c-set-style: "BSD"
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: nil
 * End:
 */
