#ifndef __HVMLOADER_MARKERS_H__
#define __HVMLOADER_MARKERS_H__

#define BIOS_VENDOR_MARKER "##############################################BIOS_VENDOR_MARKER"
#define BIOS_VERSION_MARKER "#############################################BIOS_VERSION_MARKER"

#define SYS_MANUFACTURER_MARKER "#########################################SYS_MANUFACTURER_MARKER"
#define SYS_PRODUCT_NAME_MARKER "#########################################SYS_PRODUCT_NAME_MARKER"
#define SYS_PRODUCT_VERSION_MARKER "######################################SYS_PRODUCT_VERSION_MARKER"
#define SYS_PRODUCT_SERIAL_MARKER "#######################################SYS_PRODUCT_SERIAL_MARKER"

#define OEM_MARKER "######################################################OEM_MARKER"

struct bios_vendor_struct {
    char marker[65];
    char value[65];
} bios_vendor = {BIOS_VENDOR_MARKER, "Xen"};

struct bios_version_struct {
    char marker[65];
    char value[65];
} bios_version = {BIOS_VERSION_MARKER, BIOS_VERSION_MARKER};

struct sys_manufacturer_struct {
    char marker[65];
    char value[65];
} sys_manufacturer = {SYS_MANUFACTURER_MARKER, "Xen" };

struct sys_product_name_struct {
    char marker[65];
    char value[65];
} sys_product_name = {SYS_PRODUCT_NAME_MARKER, "HVM domU"};

struct sys_product_version_struct {
    char marker[65];
    char value[65];
} sys_product_version = {SYS_PRODUCT_VERSION_MARKER, SYS_PRODUCT_VERSION_MARKER};

struct sys_product_serial_struct {
    char marker[65];
    char value[65];
} sys_product_serial = {SYS_PRODUCT_SERIAL_MARKER, SYS_PRODUCT_SERIAL_MARKER};

struct oem_struct {
    char marker[65];
    char value[65];
} oem = {OEM_MARKER, "Xen"};

#endif /* __HVMLOADER_MARKERS_H__ */
