
#include <asm/asm_defns.h>

	.text
#if defined(__x86_64__)
	.code64
#else
	.code32
#endif

/* Linkage for x86 */
#define __ALIGN .align 16,0x90
#define __ALIGN_STR ".align 16,0x90"
#define ALIGN __ALIGN
#define ALIGN_STR __ALIGN_STR
#define ENTRY(name)                             \
  .globl name;                                  \
  ALIGN;                                        \
  name:

ENTRY(start)
	ud2

	.align 16
ENTRY(hxen_info)
	.fill 1024,4,0

#if defined(__x86_64__)
#define r(reg) %r##reg
#else /* defined(__i386__) */
#define r(reg) %e##reg
#endif

#if defined(__i386__)

#define os_code_windows_cpu(reg)	 \
.section .os_code.windows.cpu.reg,""	;\
	.long 1f - 4			;\
	movzb %fs:0x51,r(reg)		;\
1:					;\
.previous

#define os_code_windows_current(reg)	  \
.section .os_code.windows.current.reg,"" ;\
	.long 1f - 4			 ;\
	mov %fs:0x0,r(reg)		 ;\
	mov 0x0(r(reg)),r(reg)		 ;\
	mov 0x8(r(reg)),r(reg)		 ;\
1:					 ;\
.previous

#else /* defined(__x86_64__) */
 
/* PLJ TODO FIXME find correct offsets for x64 */

#define os_code_windows_cpu(reg)	 \
.section .os_code.windows.cpu.reg,""	;\
	.long 1f - 4			;\
	movzb %gs:0x51,r(reg)		;\
1:					;\
.previous

#define os_code_windows_current(reg)	  \
.section .os_code.windows.current.reg,"" ;\
	.long 1f - 4			 ;\
	mov %gs:0x0,r(reg)		 ;\
	mov 0x0(r(reg)),r(reg)		 ;\
	mov 0x8(r(reg)),r(reg)		 ;\
1:					 ;\
.previous

#endif

os_code_windows_cpu(ax)
os_code_windows_cpu(bx)
os_code_windows_cpu(di)
os_code_windows_current(ax)
os_code_windows_current(bx)
os_code_windows_current(di)

#if defined(__i386__)

#define os_code_macos_cpu(reg)      \
.section .os_code.macos.cpu.reg,"" ;\
	.long 1f - 4		   ;\
	movl %gs:0x24,r(reg)	   ;\
1:				   ;\
.previous

#define os_code_macos_current(reg)      \
.section .os_code.macos.current.reg,"" ;\
	.long 1f - 4		       ;\
	ud2			       ;\
1:				       ;\
.previous

os_code_macos_cpu(ax)
os_code_macos_cpu(bx)
os_code_macos_cpu(di)
os_code_macos_current(ax)
os_code_macos_current(bx)
os_code_macos_current(di)

#endif
