
#include <xen/config.h>
#include <xen/init.h>
#include <xen/lib.h>
#include <xen/types.h>
#include <xen/stdarg.h>
#include <xen/sched.h>
#include <xen/domain.h>
#include <xen/serial.h>
#include <xen/hypercall.h>
#include <asm-x86/current.h>
#include <asm/guest_access.h>
#include <asm/p2m.h>
#include <asm/hvm/support.h>
#include <asm-x86/hvm/vmx/vmx.h>

#include <hxen.h>
#include <hxen_desc.h>

struct mmio_pages mmio_pages[NR_MMIO_PAGES];

#if 0
void __start_xen(void)
{
	extern void start_vmx(void);
	struct ns16550_defaults ns16550 = {
		.data_bits = 8,
		.parity    = 'n',
		.stop_bits = 1
	};

	printk("Hello _start_xen %d\n", 10);

	init_cpu_to_node();	/* currently sets all nodes to 0 */

	hxen_mm_init();

	start_vmx();
#if 0
	ns16550_set_opt(0, "115200,8n1");
	ns16550.io_base = 0x3f8;
	ns16550.irq     = 4;
	ns16550_init(0, &ns16550);
#if 0
	ns16550_set_opt(1, "115200,8n1");
	ns16550.io_base = 0x2f8;
	ns16550.irq     = 3;
	ns16550_init(1, &ns16550);
#endif
	serial_init_preirq();

	serial_puts(0, "Hello serial\n");
#endif
}
#endif

void hostsched_setup_vm(struct vcpu *, struct vm_info_shared *);
void hostsched_halt_vm(struct vcpu *);

long __interface_fn
hxen_run_vm(struct vm_info_shared *vi)
{
    struct domain *d;
    static int init_done = 0;

    switch (init_done) {
    case 0: {
	struct vcpu *v;
	int i;

	ASSERT(current == dom0->vcpu[0]);

	d = domain_create(1, DOMCRF_hvm, 0);
	if (d == NULL) {
	    printk("domain create failed\n");
	    return -1;
	}
	printk("domain %d: %p\n", d->domain_id, d);
	vi->domain = d;

	v = alloc_vcpu(d, 0, smp_processor_id());
	if (v == NULL) {
	    printk("alloc vcpu failed\n");
	    return -1;
	}
	printk("domain %d vcpu %d: %p on cpu %d\n", d->domain_id,
	       v->vcpu_id, v, v->processor);
	vi->vcpu = v;

	hostsched_setup_vm(v, vi);

	local_irq_disable();
	set_current(v);
	vcpu_switch_host_cpu(v);
	local_irq_enable();
	init_fpu();

	d->max_pages = vi->vi_nrpages;

	{
	    extern void shadow_init_allocation(struct domain *d,
					       unsigned long mb);
	    // Rule of thumb, 1MB shadow for every 128MB guest memory.
	    shadow_init_allocation(d, (d->max_pages >> (7 + (20 - PAGE_SHIFT))));
	}

	for (i = 0; i < d->max_pages; i++) {
	    /* from assign_pages -- assign_pages only works on heap pages */
	    struct page_info *pg = mfn_to_page(vi->vi_p2m[i]);
	    d->tot_pages++;
	    ASSERT(page_get_owner(pg) == NULL);
	    if (!((pg->count_info & ~(PGC_allocated | 1)) == 0)) {
		printk("page %p caf %x\n", pg, pg->count_info);
		printk("p2m %p\n", vi->vi_p2m);
	    }
	    ASSERT((pg->count_info & ~(PGC_allocated | 1)) == 0);
	    page_set_owner(pg, d);
	    wmb(); /* Domain pointer must be visible before updating refcnt. */
	    pg->count_info = PGC_allocated | 1;
	    list_add_tail(&pg->list, &d->page_list);
	    if (i < 0xa0 || i >= 0xc0) {
                long rc;
		rc = guest_physmap_add_page(d, i, vi->vi_p2m[i], 0);
		if (rc != 0) {
		    printk("guest_physmap_add_page %x %x => %ld\n", i,
			   vi->vi_p2m[i], rc);
		}
	    }
	    ASSERT(mfn_to_vmapaddr(vi->vi_p2m[i])->vaddr);
	}

#define SPECIALPAGE_BUFIOREQ    1
#define SPECIALPAGE_IOREQ    3
#define NR_SPECIAL_PAGES     5
	{
	    struct hvm_ioreq_page *iorp;
	    long rc;
	    extern int hvm_set_ioreq_page
		(struct domain *, struct hvm_ioreq_page *, unsigned long);

	    iorp = &d->arch.hvm_domain.ioreq;
	    rc = hvm_set_ioreq_page(d, iorp, d->max_pages -
				    NR_SPECIAL_PAGES + SPECIALPAGE_IOREQ);
	    if (rc)
		printk("set ioreq -> %ld\n", rc);
	    ASSERT(rc == 0);
	}

	{
	    struct hvm_ioreq_page *iorp;
	    long rc;
	    extern int hvm_set_ioreq_page
		(struct domain *, struct hvm_ioreq_page *, unsigned long);

	    iorp = &d->arch.hvm_domain.buf_ioreq;
	    rc = hvm_set_ioreq_page(d, iorp, d->max_pages -
				    NR_SPECIAL_PAGES + SPECIALPAGE_BUFIOREQ);
	    if (rc)
		printk("set buf ioreq -> %ld\n", rc);
	    ASSERT(rc == 0);
	}

	{
	    extern int hxen_printk_enabled;
	    hxen_printk_enabled = 0;
	}

	vmx_do_resume(current);
    }

	init_done = 1;
	return 1;

    case 1:
	ASSERT(current == vi->vcpu);
	domain_unpause_by_systemcontroller(current->domain);
	if (!vcpu_runnable(current)) {
	    printk("vcpu not runnable %lx %x %x\n", current->pause_flags,
		   atomic_read(&current->pause_count),
		   atomic_read(&current->domain->pause_count));
	    return -1;
	}
	schedule_vcpu(current);
	init_done = 2;
	break;

    case 2:
	ASSERT(current == vi->vcpu);
	if ( test_and_clear_bit(_VPF_blocked_in_xen,
				&current->pause_flags) ) {
	    vcpu_wake(current);
	    schedule_vcpu(current);
	}
	if (current->runstate.state >= RUNSTATE_blocked)
	    printk("1 run_vm not ready %x %lx %x %x\n",
		   current->runstate.state, current->pause_flags,
		   atomic_read(&current->pause_count),
		   atomic_read(&current->domain->pause_count));
	hvm_do_resume(current);
	break;
    }

    while (hxen_info.ki_running && !current->domain->is_shutting_down) {
	local_irq_disable();
	if (!softirq_pending_vcpu(current) &&
	    current->runstate.state >= RUNSTATE_blocked) {
	    hostsched_halt_vm(current);
	} else {
	    local_irq_enable();
	    if (current->runstate.state == RUNSTATE_runnable)
		schedule_vcpu(current);
	    vmx_asm_do_vmentry(current);
	}
	if (current->runstate.state >= RUNSTATE_blocked &&
	    test_bit(_VPF_blocked_in_xen, &current->pause_flags)) {
	    perfc_incr(blocked_in_xen);
	    return 0;
	}
    }
    return -1;
}

void __interface_fn
hxen_shutdown_xen(void)
{
    int cpu;

    set_current(idle_vcpu[smp_processor_id()]);
    for_each_online_cpu(cpu) {
	cpu_raise_softirq(cpu, 0);
    }

    smp_send_stop();
}

typedef unsigned long hxen_hypercall_t(unsigned long, unsigned long,
				       unsigned long, unsigned long,
				       unsigned long);

#define HYPERCALL(x)						\
    [ __HYPERVISOR_ ## x ] = (hxen_hypercall_t *) do_ ## x

static hxen_hypercall_t *hxen_hypercall_table[NR_hypercalls] = {
    HYPERCALL(xen_version),
    HYPERCALL(domctl),
};

long __interface_fn
hxen_do_hypercall(struct hxen_hypercall_desc *khd)
{
    long ret;

    if (khd->khd_op >= NR_hypercalls ||
	hxen_hypercall_table[khd->khd_op] == NULL)
	return -ENOSYS;

    hxen_context_switch(dom0->vcpu[0]);
    ret = hxen_hypercall_table[khd->khd_op](khd->khd_arg[0], khd->khd_arg[1],
					    khd->khd_arg[2], khd->khd_arg[3],
					    khd->khd_arg[4]);

    return ret;
}

long __interface_fn
hxen_do_memop(struct hxen_memop_desc *kmd)
{
    long ret;

    hxen_context_switch(dom0->vcpu[0]);
    ret = do_memory_op(kmd->kmd_cmd, guest_handle_cast(kmd->kmd_kma, void));

    return ret;
}

long __interface_fn
hxen_do_hvmop(struct hxen_hvmop_desc *khd)
{
    long ret;

    hxen_context_switch(dom0->vcpu[0]);
    ret = do_hvm_op(khd->khd_cmd, guest_handle_cast(khd->khd_kha, void));

    return ret;
}

long __interface_fn
hxen_do_domctl(struct hxen_domctl_desc *kdd)
{
    long ret;

    hxen_context_switch(dom0->vcpu[0]);
    ret = do_domctl(kdd->kdd_xd);

    return ret;
}
