#ifndef __X86_32_BUG_H__
#define __X86_32_BUG_H__

struct bug_frame_str {
    unsigned char mov[1];
    unsigned long str;
} __attribute__((packed));
#define BUG_MOV_STR "\xbc"

#define dump_execution_state()                          \
    asm volatile (                                      \
        "ud2 ; ret $%c0"                                \
        : : "i" (BUGFRAME_dump) )

#define WARN()                                          \
 do { \
  printk("WARN %s %s:%d\n", __FUNCTION__, __FILE__, __LINE__); \
  if (0) \
    asm volatile (                                      \
        "ud2 ; ret $%c0 ; .byte 0xbc ; .long %c1"       \
        : : "i" (BUGFRAME_warn | (__LINE__<<2)),        \
            "i" (__FILE__) ) \
 ; } while (0)

#define BUG()                                           \
 do { \
  printk("BUG %s %s:%d\n", __FUNCTION__, __FILE__, __LINE__); \
    asm volatile (                                      \
        "ud2 ; ret $%c0 ; .byte 0xbc ; .long %c1"       \
        : : "i" (BUGFRAME_bug | (__LINE__<<2)),         \
            "i" (__FILE__) ) \
 ; } while (0)

#ifndef __KXEN__
#define assert_failed(p)                                \
    asm volatile (                                      \
        "ud2 ; ret $%c0 ; .byte 0xbc ; .long %c1"       \
        " ; .byte 0xbc ; .long %c2"                     \
        : : "i" (BUGFRAME_assert | (__LINE__<<2)),      \
            "i" (__FILE__), "i" (#p) )
#endif

#endif /* __X86_32_BUG_H__ */
