
#ifndef _KXEN_DESC_H_
#define _KXEN_DESC_H_

#include <public/xen.h>
#include <public/domctl.h>
#include <public/memory.h>
#include <public/hvm/hvm_op.h>

struct hxen_hypercall_desc {
    uint64_t khd_op;
    uint64_t khd_arg[5];
};

/* Same structure, hard to grep member names... */
struct privcmd_hypercall {
    uint64_t op;
    uint64_t arg[5];
};

union hxen_memop_arg {
    xen_memory_reservation_t reservation;
    xen_memory_exchange_t exchange;
    domid_t domid;
    xen_add_to_physmap_t add_to_physmap;
    xen_translate_gpfn_list_t translate_gpfn;
    xen_foreign_memory_map_t foreign_memory_map;
    xen_machphys_mfn_list_t machphys_mfn_list;
    xen_machphys_mapping_t machphys_mapping;
    xen_memory_map_t memory_map;
    xen_remove_from_physmap_t remove_from_physmap;
};
typedef union hxen_memop_arg hxen_memop_arg_u;
DEFINE_XEN_GUEST_HANDLE(hxen_memop_arg_u);

struct hxen_memop_desc {
    unsigned kmd_cmd;
    XEN_GUEST_HANDLE(hxen_memop_arg_u) kmd_kma;
};

union hxen_hvmop_arg {
    xen_hvm_param_t param;
    xen_hvm_set_pci_intx_level_t set_pci_intx_level;
    xen_hvm_set_isa_irq_level_t set_isa_irq_level;
    xen_hvm_set_pci_link_route_t set_pci_link_route;
    xen_hvm_modified_memory_t modified_memory;
    xen_hvm_set_mem_type_t set_mem_type;
    xen_hvm_track_dirty_vram_t track_dirty_vram;
};
typedef union hxen_hvmop_arg hxen_hvmop_arg_u;
DEFINE_XEN_GUEST_HANDLE(hxen_hvmop_arg_u);

struct hxen_hvmop_desc {
    unsigned khd_cmd;
    XEN_GUEST_HANDLE(hxen_hvmop_arg_u) khd_kha;
};

struct hxen_domctl_desc {
    XEN_GUEST_HANDLE(xen_domctl_t) kdd_xd;
};

struct privcmd_mmap_entry {
    uint64_t va;
    uint64_t mfn;
    uint64_t npages;
};

struct hxen_mmapbatch_desc {
    int kmd_num;	   /* number of pages to populate */
    domid_t kmd_domid;	   /* target domain */
    uint64_t kmd_addr;	   /* virtual address */
    XEN_GUEST_HANDLE(xen_pfn_t) kmd_arr;
    	                   /* array of mfns - top nibble set on err */
};

struct hxen_munmap_desc {
    int kmd_num;		/* number of pages to unmap */
    uint64_t kmd_addr;		/* virtual address */
};

typedef struct hxen_vmapping hxen_vmapping_t;
DEFINE_XEN_GUEST_HANDLE(hxen_vmapping_t);
struct hxen_vmappings_desc {
    uint32_t kvd_nrpages;
    XEN_GUEST_HANDLE(hxen_vmapping_t) kvd_vmappings;
};

#endif
