
#ifndef _KXEN_INFO_H
#define _KXEN_INFO_H

#include <hxen_os.h>
#include <public/xen.h>

#if !defined(__x86_64__) && !defined(NO_EXCEPTION_RECORD_HOOK)
#define USE_EXCEPTION_RECORD_HOOK 1
#endif

#if defined(__x86_64) && !defined(WINNT)
#define __interface_fn __cdecl __attribute__ ((ms_abi))
#else
#define __interface_fn __cdecl
#endif

struct vm_info_shared;

struct /* __WINPACKED__ */ hxen_info {
    int (__interface_fn *ki_printf)(const char *fmt, ...);
    uint32_t ki_max_page;
    uint32_t ki_xenheap_page_count;
    uint32_t *ki_xenheap_pages;
    unsigned char *ki_xenheap_va;
    void *ki_frametable;
    void *ki_vmaptable;
    void (__interface_fn *ki_kick_cpu)(unsigned int, unsigned int);
    void (__interface_fn *ki_kick_vcpu)(struct vm_info_shared *, unsigned int);
    void (__interface_fn *ki_timer_interrupt)(void);
    void (__interface_fn *ki_timer_interrupt_vcpu)(struct vm_info_shared *);
    uint64_t ki_cpu_active_mask __WINPACKED__;
    void (__interface_fn *ki_signal_idle_thread)(unsigned int);
    uint32_t ki_running;
    void (__interface_fn *ki_set_host_preemption)(unsigned int);
    void (__interface_fn *ki_set_timer)(unsigned int, uint64_t);
    void (__interface_fn *ki_set_timer_vcpu)(struct vm_info_shared *,
					     uint64_t);
    uint32_t (__interface_fn *ki_get_unixtime)(void);
    uint64_t (__interface_fn *ki_get_hostime)(void);
    uint32_t ki_hostime_tick_frequency;
    void (__interface_fn *ki_halt_vm)(struct vm_info_shared *);
    void (__interface_fn *ki_wake_vm)(struct vm_info_shared *);
    void (__interface_fn *ki_on_each_cpu)(void (*)(void *), void *);
    void *(__interface_fn *ki_map_pages)(unsigned int, void *);
    int (__interface_fn *ki_unmap_pages)(unsigned int, void *);
    void (__interface_fn *ki_set_current)(void *);
    void *(__interface_fn *ki_get_current)(void);
    int (__interface_fn *ki_host_processor_id)(void);
    void *ki_dom0_current;
#ifdef __KXEN_MACOS__
    unsigned long (__interface_fn *ki_copy_to_user)(void *, const void *,
						    unsigned long);
    unsigned long (__interface_fn *ki_copy_from_user)(void *, const void *,
						      unsigned long);
#endif
};

struct domain;
struct vcpu;

struct vm_info_shared {
    uint32_t vi_nrpages;
    uint32_t *vi_p2m;
    struct domain *domain;
    struct vcpu *vcpu;
};

struct hxen_vmapping {
    XEN_GUEST_HANDLE(void) vaddr;
};

struct hxen_vmap {
    void *vaddr;
};

/* 13 bits = 8192 pages = 32MB (< max mdl size) */
#define KXEN_VMAPPING_SHIFT 13

#define KXEN_PAGE_SHIFT 12
#define KXEN_PAGE_SIZE (1UL << KXEN_PAGE_SHIFT)
#define KXEN_PAGE_MASK (~(KXEN_PAGE_SIZE-1))

#endif
