
#ifndef _KXEN_LINK_H_
#define _KXEN_LINK_H_

#include <hxen_os.h>

#if defined(KXEN_DEFINE_SYMBOLS_PROTO) || defined(KXEN_DEFINE_SYMBOLS_CODE)

#include <hxen_desc.h>

#define KXEN_PROTOTYPES(type)						\
    type struct hxen_info *hxen_info;					\
    type int hxen_sizeof_struct_page_info;				\
    type void (__cdecl *hxen_start_xen)(void);				\
    type long (__cdecl *hxen_run_vm)(/* struct vm_info_shared * */void *); \
    type void (__cdecl *hxen_dispatch_ipi)(unsigned int);		\
    type void (__cdecl *hxen_dispatch_ivi)(struct vm_info_shared *,	\
					   unsigned int);		\
    type void (__cdecl *hxen_do_softirq)(void);				\
    type void (__cdecl *hxen_handle_keypress)(unsigned char);		\
    type void (__cdecl *hxen_shutdown_xen)(void);			\
    type long (__cdecl *hxen_do_hypercall)(struct hxen_hypercall_desc *); \
    type long (__cdecl *hxen_do_memop)(/* struct hxen_memop_desc * */void *); \
    type long (__cdecl *hxen_do_hvmop)(struct hxen_hvmop_desc *);	\
    type long (__cdecl *hxen_do_domctl)(struct hxen_domctl_desc *);

#endif

#if defined(KXEN_DEFINE_SYMBOLS_CODE)
#include <public/libelf.h>

#ifndef PRIx64
#if defined(_WIN32)
#define PRIx64 "I64x"
#elif defined(__APPLE__) && defined(KERNEL)
#define PRIx64 "qx"
#else
#error unsupported os
#endif
#endif

static int get_elf_sym(struct elf_binary *elf, unsigned char *hv,
		       const char *n, int vsize, void *vp)
{
    uint64_t v;
    uint64_t base;
    int shndx;
    const elf_sym *sym;
    const elf_shdr *shdr;

    sym = elf_sym_by_name(elf, n);
    if (sym == NULL)
	return -1;
    shndx = elf_uval(elf, sym, st_shndx);
    switch (shndx) {
    case SHN_UNDEF:
    case SHN_ABS:
	base = 0;
	break;
    case SHN_COMMON:
	return -1;
	break;
    default:
	shdr = elf_shdr_by_index(elf, shndx);
	if ( shdr == NULL )
	    return -1;
	base = elf_uval(elf, shdr, sh_addr) + (uint64_t)(uintptr_t)hv;
	break;
    }
    v = elf_uval(elf, sym, st_value) + base;
    dprintk("sym %s = %" PRIx64 " (base %" PRIx64 ")\n", n, v, base);
    memcpy(vp, &v, vsize);
    return 0;
}

#define GET_ELF_SYM(n, t, v) do {				\
	int ret = get_elf_sym(elf, hv, n, sizeof(t), &v);	\
	if (ret) {						\
	    if (missing_symbol)					\
		*missing_symbol = n;				\
	    return ret;						\
	}							\
} while (/* CONSTCOND */0)

#define KXEN_GET_SYMS(fn_name) int					\
    fn_name(struct elf_binary *elf, unsigned char *hv,			\
            const char **missing_symbol)				\
{									\
									\
    GET_ELF_SYM("hxen_info", struct hxen_info *, hxen_info);		\
    GET_ELF_SYM("__start_xen", void (__cdecl *)(void), hxen_start_xen); \
    GET_ELF_SYM("hxen_run_vm", long (__cdecl *)(struct vm_info_shared *), \
                hxen_run_vm);						\
    GET_ELF_SYM("hxen_dispatch_ipi", void (__cdecl *)(unsigned int),	\
                hxen_dispatch_ipi);					\
    GET_ELF_SYM("hxen_dispatch_ivi",					\
		void (__cdecl *)(struct vm_info_shared *, unsigned int), \
                hxen_dispatch_ivi);					\
    GET_ELF_SYM("hxen_do_softirq", void (__cdecl *)(void), hxen_do_softirq); \
    GET_ELF_SYM("__sizeof_struct_page_info", int,			\
                hxen_sizeof_struct_page_info);				\
    GET_ELF_SYM("hxen_handle_keypress", void (__cdecl *)(unsigned char), \
                hxen_handle_keypress);					\
    GET_ELF_SYM("hxen_shutdown_xen",					\
		void (__cdecl *)(void), hxen_shutdown_xen);		\
    GET_ELF_SYM("hxen_do_hypercall",					\
		long (__cdecl *)(struct hxen_hypercall_desc *),		\
		hxen_do_hypercall);					\
    GET_ELF_SYM("hxen_do_memop", long (__cdecl *)(struct hxen_memop_desc *), \
                hxen_do_memop);						\
    GET_ELF_SYM("hxen_do_hvmop", long (__cdecl *)(struct hxen_hvmop_desc *), \
		hxen_do_hvmop);						\
    GET_ELF_SYM("hxen_do_domctl",					\
		long (__cdecl *)(struct hxen_domctl_desc *), hxen_do_domctl); \
    return 0;								\
}

#define KXEN_CLEAR_SYMS(fn_name) void					\
    fn_name(void)							\
{									\
									\
    hxen_info = NULL;							\
    hxen_start_xen = NULL;						\
    hxen_run_vm = NULL;							\
    hxen_dispatch_ipi = NULL;						\
    hxen_dispatch_ivi = NULL;						\
    hxen_do_softirq = NULL;						\
    hxen_sizeof_struct_page_info = 0;					\
    hxen_handle_keypress = NULL;					\
    hxen_shutdown_xen = NULL;						\
    hxen_do_hypercall = NULL;						\
    hxen_do_memop = NULL;						\
    hxen_do_hvmop = NULL;						\
    hxen_do_domctl = NULL;						\
}
#endif

#endif
