
#ifndef KXEN_STANDALONE
#include <linux/types.h>
#include <public/libelf.h>
#include <linux/module.h>
#else
#include <err.h>
#include <errno.h>
#include <stdarg.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/mman.h>
#define printk printf
#define vprintk vprintf
#define __init
#define __exit
#include <public/libelf.h>
#endif

#include "hxen_info.h"

#include "hxen.hex"

unsigned char *hxen_blob, *hxen_mem = NULL;

#ifdef KXEN_STANDALONE
#include <limits.h>    /* for PAGESIZE */
#ifndef PAGESIZE
#define PAGESIZE 4096
#endif
#endif

struct hxen_info *hxen_info;
void (*hxen_call)(void);

#ifndef KXEN_STANDALONE
MODULE_AUTHOR("Citrix");
MODULE_LICENSE("GPL");
#endif

asmlinkage int ki_printf(const char *fmt, ...)
{
	int ret;
	va_list ap;

	va_start(ap, fmt);
	ret = vprintk(fmt, ap);
	va_end(ap);

	return ret;
}

#ifndef KXEN_STANDALONE
#define errx(v, m) do { printk(KERN_ERR "load_hxen failed %s\n", m); return(v); } while (0)
#endif

static int load_hxen(void)
{
	int ret;
	struct elf_binary elf;
	unsigned char *p;

	ret = elf_init(&elf, hxen_elf, sizeof(hxen_elf));
	if (ret != 0)
		errx(1, "elf_init");
#ifndef KXEN_STANDALONE
	elf_set_verbose(&elf);
#else
	elf_set_logfile(&elf, stderr, 10);
#endif
	elf_parse_binary(&elf);

#ifndef KXEN_STANDALONE
	hxen_mem = kmalloc(elf.pend - elf.pstart, GFP_KERNEL);
	if (hxen_mem == NULL)
		errx(1, "malloc");
	p = hxen_mem;
#else
	hxen_mem = malloc(elf.pend - elf.pstart + PAGESIZE - 1);
	if (hxen_mem == NULL)
		errx(1, "malloc");
	p = (unsigned char *)(((int) hxen_mem + PAGESIZE-1) & ~(PAGESIZE-1));
#endif
	hxen_blob = p;

	elf.dest = (void *)hxen_blob;
	elf_load_binary(&elf);

	ret = elf_reloc(&elf);
	if (ret != 0)
		errx(1, "elf_reloc");

#ifdef KXEN_STANDALONE
	ret = mprotect(hxen_blob, elf.pend - elf.pstart,
		       PROT_EXEC | PROT_WRITE | PROT_READ);
	if (ret)
		err(1, "mprotect");
	printk("add-symbol-file hxen.elf %p\n", hxen_blob);
#endif
	return 0;
}

static __init int hxen_init(void)
{
	int ret;

	ret = load_hxen();
	if (ret)
		return ret;

	printk("Hello World at %p\n", hxen_blob);

	hxen_call = (void (*)(void))(hxen_blob);
	hxen_info = (struct hxen_info *)(hxen_blob + 16);

	hxen_info->ki_printf = ki_printf;

	hxen_call();
	// ((void (*)(void))(hxen_blob))();

	return 0;
}

static __exit void hxen_exit(void)
{
#ifndef KXEN_STANDALONE
	kfree(hxen_mem);
#endif
}

#ifndef KXEN_STANDALONE
module_init(hxen_init);
module_exit(hxen_exit);
#else
int main(int argc, char **argv)
{
	return hxen_init();
}

#endif
