
#include "hxen.h"
#include "hxen_call.h"

#if !defined(USE_EXCEPTION_RECORD_HOOK)

// TODO: Add code to remove defunct vcpu threads.
#define KXEN_MAX_SUPPORTED_VCPUS 64
static struct _hxen_thread_to_vcpu {
    void * thread;
    void * vcpu;
} hxen_thread_to_vcpu[KXEN_MAX_SUPPORTED_VCPUS];

volatile long hxen_thread_cpu_high = 0;
lck_mtx_t *hxen_call_mutex = NULL;

#define CALL_LOCK() lck_mtx_lock(hxen_call_mutex)
#define CALL_UNLOCK() lck_mtx_unlock(hxen_call_mutex)

extern void ud2(void);

static void * __cdecl
hxen_new_current(void * current)
{
    void * self = current_thread();
    long high;
    long i;
    int enabled;

    if (!current)
        return NULL;

    enabled = xnu_disable_preemption();
    CALL_LOCK();
    high = hxen_thread_cpu_high;

    /* Find empty slot, if any */

    for (i = 0; i < high; i++)
    {
        if (!hxen_thread_to_vcpu[i].thread)
            break;
    }

    if (i == high)
        hxen_thread_cpu_high = high + 1;

    if (i >= KXEN_MAX_SUPPORTED_VCPUS) {
        dprintk("hxen thread_to_current table overflow.\n");
        ud2();
    }
    hxen_thread_to_vcpu[i].vcpu = current;
    hxen_thread_to_vcpu[i].thread = self;

    CALL_UNLOCK();
    if (enabled)
	xnu_enable_preemption();
    return NULL;
}
#endif

void __cdecl
hxen_set_current(void *current)
{
#if defined(USE_EXCEPTION_RECORD_HOOK)
    ((struct hxen_EXCEPTION_REGISTRATION_RECORD *)
     ((struct win_EXCEPTION_REGISTRATION_RECORD *)
      __readfsdword(0x0))->next)->current = current;
#else
    void * self = current_thread();
    long high = hxen_thread_cpu_high;
    long i;

    for (i = 0; i < high; i++) {
        if (hxen_thread_to_vcpu[i].thread == self) {
            if (!current) 
                hxen_thread_to_vcpu[i].thread = NULL;
            hxen_thread_to_vcpu[i].vcpu = current;
            return;
        }
    }
    hxen_new_current(current);
#endif
}

#if !defined(USE_EXCEPTION_RECORD_HOOK)
void * __cdecl
hxen_swap_current(void *current)
{
    void * self = current_thread();
    long high = hxen_thread_cpu_high;
    long i;
    void * previous;

    for (i = 0; i < high; i++) {
        if (hxen_thread_to_vcpu[i].thread == self) {
            previous = hxen_thread_to_vcpu[i].vcpu;
            hxen_thread_to_vcpu[i].vcpu = current;
            return previous;
        }
    }
    return hxen_new_current(current);
}
#endif

void * __cdecl
hxen_get_current(void)
{
#if defined(USE_EXCEPTION_RECORD_HOOK)
    return ((struct hxen_EXCEPTION_REGISTRATION_RECORD *)
            ((struct win_EXCEPTION_REGISTRATION_RECORD *)
             __readfsdword(0x0))->next)->current;
#else
    void *self = current_thread();
    long high = hxen_thread_cpu_high;
    long i;

    for (i = high - 1; i >= 0 ; i--) {
        if (hxen_thread_to_vcpu[i].thread == self) {
            if (!hxen_thread_to_vcpu[i].vcpu) {
                dprintk("hxen_get_current returning null!!\n");
                // __debugbreak();
            }
            return hxen_thread_to_vcpu[i].vcpu;
        }
    }
    /* BUG(); if we could but that's blob code. */
    dprintk("hxen_get_current, no value for this thread!!\n");
    ud2();
    return NULL;
#endif
}

int
hxen_try_call(long (__cdecl *fn)(void *), void *arg, void *current)
{
    int ret;
    DECLARE_EXCEPTION_REGISTRATION_RECORD(hxen_rec);

    HOOK_EXCEPTION_REGISTRATION_RECORD(hxen_rec, current);

    ret = fn(arg);

#if defined(USE_EXCEPTION_RECORD_HOOK)
    UNHOOK_EXCEPTION_REGISTRATION_RECORD(hxen_rec);
#endif

    return ret;
}
