/*
 *  hxen_cpu.c
 *  hxen
 *
 *  Copyright 2009 Citrix Systems, Inc. All rights reserved.
 *
 */

#include "hxen.h"
#include <xnu_hacks.h>

#define KXEN_DEFINE_SYMBOLS_PROTO
#include <hxen_link.h>
KXEN_PROTOTYPES(extern)

unsigned long hxen_cpu_vm = 0;

unsigned long
hxen_first_cpu(void)
{
    return 0;			/* AAA */
}

void
hxen_cpu_pin(unsigned long host_cpu)
{

    // xnu_disable_preemption();
    xnu_thread_bind(host_cpu);
    thread_block(THREAD_CONTINUE_NULL);
}

void
hxen_cpu_pin_current(void)
{
    unsigned long cpu;

    cpu = xnu_get_cpu_number();
    hxen_cpu_pin(cpu);
}

void
hxen_cpu_pin_first(void)
{
    unsigned long cpu;

    cpu = hxen_first_cpu();
    hxen_cpu_pin(cpu);
}

void
hxen_cpu_pin_vcpu(struct vm_info *vi)
{
    // KeSetTargetProcessorDpc(&vi->vi_timer_dpc, (CCHAR)vi->vi_host_cpu);
    // KeSetTargetProcessorDpc(&vi->vi_ipi_dpc, (CCHAR)vi->vi_host_cpu);
    hxen_cpu_pin(vi->vi_host_cpu);
}

void
hxen_cpu_unpin(void)
{

    // xnu_enable_preemption();
    xnu_thread_unbind();
    thread_block(THREAD_CONTINUE_NULL);
}

void
hxen_set_cpu_active_mask(void *mask, int mask_size)
{
    uint32_t affinity;

    affinity = 0x3;
    ASSERT(sizeof(affinity) <= mask_size);
    memcpy(mask, &affinity, sizeof(affinity));

    hxen_cpu_vm = 1;
}

void __cdecl
hxen_on_each_cpu(void (*fn)(void *), void *arg)
{
#if 0
    KAFFINITY affinity;
    CCHAR host_cpu;

    affinity = KeQueryActiveProcessors();
    for (host_cpu = MAXIMUM_PROCESSORS - 1; host_cpu >= 0; host_cpu--) {
	if ((affinity & to_affinity(host_cpu)) == 0)
	    continue;
	hxen_cpu_pin(host_cpu);
	dprintk("hxen_on_each_cpu on cpu %d: %p(%p)\n", host_cpu, fn, arg);
	try {
	    fn(arg);
	} except (KXEN_EXCEPTION_EXECUTE_HANDLER) {
	}
    }
    hxen_cpu_unpin();
#else
    dprintk("hxen_on_each_cpu\n");
#endif
}

int
hxen_cpu_init(void)
{
    int ret;

    ret = xnu_setup_thread_bind();
    return ret;
}
