
#include <stdarg.h>

#include "hxen.h"

struct device_extension *kdbgdevext = NULL;

int kdbgprint = 1;

// #define DPRINTK_BUFFER

#if defined(DPRINTK_BUFFER)
static char hxen_dprintk_bigbuf[65536];
static int hxen_dprintk_bigbuf_pos = 0;
#endif

#define KXEN_DPRINTK_SIZE 1024
static char hxen_dprintk_buf[KXEN_DPRINTK_SIZE + 1];
static int
hxen_vprintk(const char *fmt, va_list ap)
{
    int ret;

    if (kdbgprint == 0)
	return 0;
#if !defined(DPRINTK_BUFFER)
    ret = vsnprintf(hxen_dprintk_buf, KXEN_DPRINTK_SIZE, fmt, ap);
    hxen_dprintk_buf[KXEN_DPRINTK_SIZE] = 0;
#ifdef KXEN_XNU_HACKS
    kdp_send_message(hxen_dprintk_buf);
#else
    printf("%s", hxen_dprintk_buf);
#endif
#else
    if (hxen_dprintk_bigbuf_pos + KXEN_DPRINTK_SIZE >= 65535)
	return 0;
    ret = vsnprintf(hxen_dprintk_bigbuf + hxen_dprintk_bigbuf_pos,
		    KXEN_DPRINTK_SIZE, fmt, ap);
    hxen_dprintk_bigbuf[hxen_dprintk_bigbuf_pos + KXEN_DPRINTK_SIZE] = 0;
    hxen_dprintk_bigbuf_pos += ret;
#endif
    return ret;
}

#ifdef KXEN_DPRINTK
int __cdecl
hxen_dprintk(const char *fmt, ...)
{
    int ret;
    va_list ap;

    va_start(ap, fmt);
    ret = hxen_vprintk(fmt, ap);
    va_end(ap);

    return ret;
}
#else
int __cdecl
hxen_dprintk(const char *fmt, ...)
{
    return 0;
}
#endif

int
hxen_printk(const char *fmt, ...)
{
    int ret;
    va_list ap;

    va_start(ap, fmt);
#if defined(APPLE)
    /* XXX Some form of printk or event log? */
    ret = vprintf(fmt, ap);
#else
    ret = 0;
#endif
    hxen_vprintk(fmt, ap);
    va_end(ap);
    return ret;
}

#if defined(__x86_64__)
void kdbgrebootsup(void);
#else
void
ud2(void)
{
    asm ("ud2");
}
#endif

int kdbgdoreboot = 0;
void
kdbgreboot(void)
{
    // KeSetSystemAffinityThread(1 << 0);
#if defined(__x86_64__)
    kdbgrebootsup();
#else
#if 0
    __asm {
	/* VMXOFF */
	_emit 0x0f;
	_emit 0x01;
	_emit 0xc4;
	push 0xffffffff;
	push 0xffff0000;
	lidt [esp];
	ud2;
    }
#endif
    ud2();
#endif
}
