#include "hxen.h"
#include <sys/systm.h>
#include <mach/mach_types.h>

#include <kern/ast.h>
#include <i386/machine_routines.h>
#include <i386/cpu_data.h>
#include <i386/mp.h>
#define XNU_KERNEL_PRIVATE
#include <mach/i386/thread_status.h>

#include <kdp/kdp_internal.h>
#undef ntohs
#undef ntohl
#undef htons
#undef htonl
#include <kdp/kdp_udp.h>
#include <kdp/kdp_en_debugger.h>

// void (*orig_kdp_exception)(unsigned char *, int *, unsigned short *, unsigned int, unsigned int, unsigned int) = (void (*)(unsigned char *, int *, unsigned short *, unsigned int, unsigned int, unsigned int))0x1b74ba;
// unsigned (*kdp_vm_write)(caddr_t src, caddr_t dst, unsigned len) = (unsigned (*)(caddr_t, caddr_t, unsigned))0x1b86cb;
kdp_glob_t *xnu_kdp = (kdp_glob_t *)0x53a5a0;
// void (*xnu_kdp_raise_exception)(unsigned int, unsigned int, unsigned int, void *) = (void (*)(unsigned int, unsigned int, unsigned int, void *))0x11c007;
void (*xnu_mp_kdp_enter)(void) = (void (*)(void))0x1b051f;
void (*xnu_mp_kdp_exit)(void) = (void (*)(void))0x1afea9;

kdp_send_t *xnu_kdp_en_send_pkt = (kdp_send_t *)0x51b61c;
struct xnu_pkt {
    unsigned char	data[KDP_MAXPACKET];
    unsigned int	off, len;
    boolean_t		input;
};
struct xnu_pkt *xnu_pkt = (struct xnu_pkt *)0x51aa20;
struct xnu_addr {
    struct {
	struct in_addr		in;
	struct ether_addr	ea;
    } loc;
    struct {
	struct in_addr		in;
	struct ether_addr	ea;
    } rmt;
};
struct xnu_addr *xnu_adr = (struct xnu_addr *)0x537d18;
ushort *xnu_ip_id = (ushort *)0x549c94;
int *xnu_udp_ttl = (int *)0x4d8164;

#define KDP_LOG 0x29

typedef struct {                        /* KDP_MESSAGE notification */
    kdp_hdr_t hdr;
    uint32_t len;
    char msg[0];
} kdp_message_t;

static void
enaddr_copy(
	void	*src,
	void	*dst
)
{
	bcopy((char *)src, (char *)dst, sizeof (struct ether_addr));
}

static unsigned short
ip_sum(
	unsigned char	*c,
	unsigned int	hlen
	)
{
	unsigned int	high, low, sum;
    
	high = low = 0;
	while (hlen-- > 0) {
		low += c[1] + c[3];
		high += c[0] + c[2];
	
		c += sizeof (int);
	}
    
	sum = (high << 8) + low;
	sum = (sum >> 16) + (sum & 65535);
    
	return (sum > 65535 ? sum - 65535 : sum);
}

static void
hxen_kdp_send(unsigned short remote_port) {
    struct udpiphdr		aligned_ui, *ui = &aligned_ui;
    struct ip			aligned_ip, *ip = &aligned_ip;
    struct ether_header		*eh;
    
    if (xnu_pkt->input)
	panic("kdp_send");

    xnu_pkt->off -= sizeof (struct udpiphdr);

#if DO_ALIGN
    bcopy((char *)&xnu_pkt->data[xnu_pkt->off], (char *)ui, sizeof(*ui));
#else
    ui = (struct udpiphdr *)&xnu_pkt->data[xnu_pkt->off];
#endif
    ui->ui_next = ui->ui_prev = NULL;
    ui->ui_x1 = 0;
    ui->ui_pr = IPPROTO_UDP;
    ui->ui_len = htons((u_short)xnu_pkt->len + sizeof (struct udphdr));
    ui->ui_src = xnu_adr->loc.in;
    ui->ui_dst = xnu_adr->rmt.in;
    ui->ui_sport = htons(KDP_REMOTE_PORT);
    ui->ui_dport = remote_port;
    ui->ui_ulen = ui->ui_len;
    ui->ui_sum = 0;
#if DO_ALIGN
    bcopy((char *)ui, (char *)&xnu_pkt->data[xnu_pkt->off], sizeof(*ui));
    bcopy((char *)&xnu_pkt->data[xnu_pkt->off], (char *)ip, sizeof(*ip));
#else
    ip = (struct ip *)&xnu_pkt->data[xnu_pkt->off];
#endif
    ip->ip_len = htons(sizeof (struct udpiphdr) + xnu_pkt->len);
    ip->ip_v = IPVERSION;
    ip->ip_id = htons(*xnu_ip_id++);
    ip->ip_hl = sizeof (struct ip) >> 2;
    ip->ip_ttl = *xnu_udp_ttl;
    ip->ip_sum = 0;
    ip->ip_sum = htons(~ip_sum((unsigned char *)ip, ip->ip_hl));
#if DO_ALIGN
    bcopy((char *)ip, (char *)&xnu_pkt->data[xnu_pkt->off], sizeof(*ip));
#endif
    
    xnu_pkt->len += sizeof (struct udpiphdr);
    
    xnu_pkt->off -= sizeof (struct ether_header);
    
    eh = (struct ether_header *)&xnu_pkt->data[xnu_pkt->off];
    enaddr_copy(&xnu_adr->loc.ea, eh->ether_shost);
    enaddr_copy(&xnu_adr->rmt.ea, eh->ether_dhost);
    eh->ether_type = htons(ETHERTYPE_IP);
    
    xnu_pkt->len += sizeof (struct ether_header);
    (*xnu_kdp_en_send_pkt)(&xnu_pkt->data[xnu_pkt->off], xnu_pkt->len);
}

static void
hxen_kdp_message(unsigned char *pkt, int *len, unsigned short *remote_port,
		 char *message)
{
    kdp_message_t *rq = (kdp_message_t *)pkt;
    int msglen = strlen(message);
	
    if (msglen >= *len - sizeof(*rq) - 1)
	msglen = *len - sizeof(*rq) - 1 - 1;
	
    rq->hdr.request = KDP_LOG;
    rq->hdr.is_reply = 0;
    rq->hdr.seq = xnu_kdp->exception_seq;
    rq->hdr.key = 0;
    rq->hdr.len = sizeof (*rq);

    bcopy(message, rq->msg, msglen);
    rq->msg[msglen] = 0;

    rq->len = msglen + 1;
    rq->hdr.len += msglen + 1;
    
    *remote_port = xnu_kdp->exception_port;
    *len = rq->hdr.len;
}

void
kdp_send_message(char *message) {
    unsigned short remote_port;

    xnu_mp_kdp_enter();

    // kdp_sync_cache();

#if 0
    xnu_kdp->saved_state = saved_state;
    xnu_kdp->kdp_cpu = cpu_number();
    xnu_kdp->kdp_thread = current_thread();
#endif

    if (!xnu_kdp->is_conn)
	goto out;

    xnu_pkt->off = sizeof (struct ether_header) + sizeof (struct udpiphdr);
    xnu_pkt->len = 800;
    hxen_kdp_message((unsigned char *)&xnu_pkt->data[xnu_pkt->off],
		     (int *)&xnu_pkt->len,
		     (unsigned short *)&remote_port,
		     message);

    hxen_kdp_send(remote_port);	

    // kdp_sync_cache();

out:
    xnu_mp_kdp_exit();
}

int
xnu_disable_preemption(void)
{
    // disable_preemption();
    return ml_set_interrupts_enabled(false) ? 1 : 0;
}

void
xnu_enable_preemption(void)
{
    // enable_preemption_no_check();
    ml_set_interrupts_enabled(true);
}

int
xnu_get_cpu_number(void)
{
    return get_cpu_number();
}

#if 0
typedef struct {
    int			(*setRTCPop)(uint64_t time);
    void		(*resyncDeadlines)(void);
    void		(*initComplete)(void);
    x86_lcpu_t		*(*GetLCPU)(int cpu);
    x86_core_t		*(*GetCore)(int cpu);
    x86_die_t		*(*GetDie)(int cpu);
    x86_pkg_t		*(*GetPackage)(int cpu);
    x86_lcpu_t		*(*GetMyLCPU)(void);
    x86_core_t		*(*GetMyCore)(void);
    x86_die_t		*(*GetMyDie)(void);
    x86_pkg_t		*(*GetMyPackage)(void);
    x86_pkg_t		*(*GetPkgRoot)(void);
    void		(*LockCPUTopology)(int lock);
    boolean_t		(*GetHibernate)(int cpu);
    processor_t		(*LCPUtoProcessor)(int lcpu);
    processor_t		(*ThreadBind)(processor_t proc);
    x86_topology_parameters_t	*topoParms;
} pmCallBacks_t;

void pmKextRegister(uint32_t version, pmDispatch_t *cpuFuncs,
		    pmCallBacks_t *callbacks);

#define PM_DISPATCH_VERSION	12
#endif

static pmCallBacks_t pm_callbacks;

void
xnu_thread_bind(unsigned int cpu)
{
    if (cpu < MAX_CPUS)
	pm_callbacks.ThreadBind(pm_callbacks.LCPUtoProcessor(cpu));
}

void
xnu_thread_unbind(void)
{
    pm_callbacks.ThreadBind(PROCESSOR_NULL);
}

int
xnu_setup_thread_bind(void)
{

    memset(&pm_callbacks, 0, sizeof(pm_callbacks));

    pmKextRegister(PM_DISPATCH_VERSION, NULL, &pm_callbacks);

    if (pm_callbacks.ThreadBind == NULL)
	return ENOENT;

    return 0;
}

#define MACH_KERNEL_PRIVATE
#include <kern/timer_call.h>

static boolean_t (*xnu_timer_call_enter)(timer_call_t, uint64_t) =
    (boolean_t (*)(timer_call_t, uint64_t))0x1402fd;
								 
static void (*xnu_timer_call_setup)(timer_call_t, timer_call_func_t, timer_call_param_t) =
    (void (*)(timer_call_t, timer_call_func_t, timer_call_param_t))0x140098;

static timer_call_data_t *hxen_cpu_timer[MAXIMUM_PROCESSORS];

void
hxen_cpu_timer_call_check(unsigned int host_cpu)
{
    int enabled;

    if (hxen_cpu_timer[host_cpu] == NULL)
	return;

    if (hxen_cpu_timer[host_cpu]->deadline ==
	hxen_cpu_timer_deadline[host_cpu])
	return;

    enabled = xnu_disable_preemption();
    if (hxen_cpu_timer[host_cpu]->deadline !=
	hxen_cpu_timer_deadline[host_cpu])
	xnu_timer_call_enter(hxen_cpu_timer[host_cpu],
			     hxen_cpu_timer_deadline[host_cpu]);
    if (enabled)
	xnu_enable_preemption();
}

void
hxen_timer_call_enter(void *_t, uint64_t deadline)
{
    timer_call_data_t *t = (timer_call_data_t *)_t;

    xnu_timer_call_enter(t, deadline);
}

void *
hxen_timer_setup(void (*callback)(void *, void *), void *param)
{
    timer_call_data_t *t;

    t = (timer_call_data_t *)kernel_malloc(sizeof(timer_call_data_t));
    if (t == NULL) {
	fail_msg("hxen_timer_setup kernel_malloc");
	return NULL;
    }
    xnu_timer_call_setup(t,
			 (void (*)(timer_call_param_t,
				   timer_call_param_t))callback,
			 param);
    return t;
}

void
hxen_cpu_timer_call_enter(unsigned int host_cpu, uint64_t deadline)
{
    if (hxen_cpu_timer[host_cpu] == NULL)
	return;
    hxen_timer_call_enter(hxen_cpu_timer[host_cpu], deadline);
}

void
hxen_cpu_timer_setup(unsigned int host_cpu, void (*callback)(void *, void *))
{
    hxen_cpu_timer[host_cpu] = hxen_timer_setup(callback, (void *)host_cpu);
}
