
#ifndef _KXENCTLLIB_H_
#define _KXENCTLLIB_H_

#if !defined(_WIN32)
typedef enum BOOLEAN { FALSE = 0, TRUE = 1, } BOOLEAN;
typedef int HANDLE;
#define INVALID_HANDLE_VALUE -1
#endif

#include <hxen_desc.h>
#include <hxen_desc_sys.h>

int hxen_manage_driver(BOOLEAN, BOOLEAN);
HANDLE hxen_open(int, BOOLEAN);
void hxen_close(HANDLE);
int hxen_init(HANDLE);
int hxen_shutdown(HANDLE);
int hxen_load(HANDLE, const char *);
int hxen_unload(HANDLE);
int hxen_output_version_info(HANDLE, FILE *);
int hxen_trigger_keyhandler(HANDLE, const char *);
int hxen_hypercall(HANDLE, struct hxen_hypercall_desc *);
int hxen_hvmop(HANDLE, struct hxen_hvmop_desc *);
int hxen_memop(HANDLE, struct hxen_memop_desc *);
int hxen_domctl(HANDLE, struct hxen_domctl_desc *);
int hxen_mmapbatch(HANDLE, struct hxen_mmapbatch_desc *);
int hxen_munmap(HANDLE, struct hxen_munmap_desc *);
int hxen_vmappings(HANDLE, struct hxen_vmappings_desc *);
int hxen_execute(HANDLE);
#if defined(_WIN32)
int hxen_set_ioemu_events(HANDLE, struct hxen_ioemu_events_desc *);
#endif
int hxen_set_ioreq_complete(HANDLE);

#endif
