/*
 *  hxen_ioctl.h
 *  hxen
 *
 *  Copyright 2009 Citrix Systems, Inc. All rights reserved.
 *
 */

#ifndef _KXEN_IOCTL_H_
#define _KXEN_IOCTL_H_

#include <stdint.h>
#include <sys/ioctl.h>
#include <sys/ioccom.h>

#define	KXEN_IO(nr)		_IO('K', nr)
#define	KXEN_IOR(nr, s)		_IOR('K', nr, s)
#define	KXEN_IOW(nr, s)		_IOW('K', nr, s)
#define	KXEN_IOWR(nr, s)	_IOWR('K', nr, s)

#include <hxen_desc.h>
#include <hxen_desc_sys.h>

struct hxen_version_desc {
    uint32_t kvd_driver_version_major;
    uint32_t kvd_driver_version_minor;
    char kvd_driver_version_tag[32];
};

struct hxen_load_desc {
    XEN_GUEST_HANDLE_64(uint8) kld_uvaddr;
    uint32_t kld_size;
};

#define	KXENVERSION		KXEN_IOR(1, struct hxen_version_desc)
#define	KXENLOAD		KXEN_IOW(2, struct hxen_load_desc)
#define	KXENUNLOAD		KXEN_IO(3)
#define	KXENINIT		KXEN_IO(4)
#define	KXENSHUTDOWN		KXEN_IO(5)
#define	KXENREBOOT		KXEN_IO(6)
#define	KXENKEYHANDLER		KXEN_IOW(7, char *)

#define	KXENHYPERCALL		KXEN_IOW(10, struct hxen_hypercall_desc)
#define	KXENMEMOP		KXEN_IOW(11, struct hxen_memop_desc)
#define	KXENHVMOP		KXEN_IOW(12, struct hxen_hvmop_desc)
#define	KXENDOMCTL		KXEN_IOW(13, xen_domctl_t)
#define	KXENMMAPBATCH		KXEN_IOWR(14, struct hxen_mmapbatch_desc)
#define	KXENMUNMAP		KXEN_IOW(15, struct hxen_munmap_desc)
#define	KXENVMAPPINGS		KXEN_IOW(16, struct hxen_vmappings_desc)
#define	KXENEXECUTE		KXEN_IO(17)
#define	KXENSETIOEMUEVENTS	KXEN_IOW(18, struct hxen_ioemu_events_desc)
#define	KXENIOREQCOMPLETE	KXEN_IO(19)

#endif	/* _KXEN_IOCTL_H_ */
