
#ifndef _KXEN_H_
#define _KXEN_H_

#if defined(_WIN32)
#include <windows.h>
#endif
#include <hxen_desc.h>

#define HV_SIZE_MIN 512
#define HV_SIZE_MAX (512*1024*1024)

int hxen_setup(void);

void hxen_exit(void);

unsigned char *hxen_alloc_mem(size_t guest_size);

int hxen_run(void);

int hxen_fd(void);

int hxen_xc_hvmop(unsigned, union hxen_hvmop_arg *);
int hxen_xc_memop(unsigned, union hxen_memop_arg *);
int hxen_xc_domctl(struct xen_domctl *);
int hxen_xc_version(int, void *);
void *hxen_xc_mmapbatch(xen_pfn_t *, int, int, domid_t);
void hxen_xc_munmap(void *, int);
int hxen_xc_keyhandler(const char *);
#if defined(_WIN32)
int hxen_ioemu_events(HANDLE, HANDLE);
#endif

void hxen_ioreq_complete(void);

int xc_hvm_build(int xc_handle, uint32_t domid, int memsize,
                 const char *image_name);

#endif
