/*++

Copyright (c) Citrix Corporation.  All rights reserved.

Module Name:

    tenkei2.h

Abstract:

    This is the header file for the user mode tenkei2 program.  That is,
    for the program which loads and controls the tenkei2 driver.

Environment:

    User mode

--*/

#if !defined(_TENKEI2_H)
#define _TENKEI2_H

#define DRIVER_FUNC_INSTALL     0x01
#define DRIVER_FUNC_REMOVE      0x02

#define DRIVER_NAME       "tenkei2"

BOOLEAN
ManageDriver(
    LPCTSTR  DriverName,
    LPCTSTR  PathName,
    USHORT   Function
    );

HANDLE
InitDriver(
    void
    );

VOID
ExitDriver(
    HANDLE
    );

BOOLEAN
Ioctl(
    HANDLE      hDevice,
    ULONG       ControlCode,
    PVOID       InBuffer,
    ULONG       InBufferLength,
    PVOID       OutBuffer,
    ULONG       OutBufferLength,
    PULONG      BytesReturned
    );

typedef struct {
    PVOID       Base;
    ULONG       Length;
} MEMDESC, *PMEMDESC;

BOOLEAN
LoadBlob(
    PMEMDESC
    );

BOOLEAN
InstallBlob(
    HANDLE,
    PMEMDESC
    );

#endif

