/******************************************************************************
 * xc_domain.c
 *
 * API for manipulating and obtaining information on domains.
 *
 * Copyright (c) 2003, K A Fraser.
 */

#include "xc_private.h"
// #include "xg_save_restore.h"
#include <public/memory.h>
#include <public/hvm/hvm_op.h>

#include <hxen-host.h>

int xc_domain_set_time_offset(int xc_handle,
                              uint32_t domid,
                              int32_t time_offset_seconds)
{
    DECLARE_DOMCTL;
    domctl.cmd = XEN_DOMCTL_settimeoffset;
    domctl.domain = (domid_t)domid;
    domctl.u.settimeoffset.time_offset_seconds = time_offset_seconds;
    return do_domctl(xc_handle, &domctl);
}

int xc_domain_memory_translate_gpfn_list(int xc_handle,
                                         uint32_t domid,
                                         unsigned long nr_gpfns,
                                         xen_pfn_t *gpfn_list,
                                         xen_pfn_t *mfn_list)
{
    int err;
    struct xen_translate_gpfn_list translate_gpfn_list = {
        .domid    = domid,
        .nr_gpfns = nr_gpfns,
    };
    set_xen_guest_handle(translate_gpfn_list.gpfn_list, gpfn_list);
    set_xen_guest_handle(translate_gpfn_list.mfn_list, mfn_list);

    err = xc_memory_op(xc_handle, XENMEM_translate_gpfn_list, &translate_gpfn_list);

    if ( err != 0 )
    {
        DPRINTF("Failed translation for dom %d (%ld PFNs)\n",
                domid, nr_gpfns);
        errno = -err;
        err = -1;
    }

    return err;
}
