/******************************************************************************
 * xc_misc.c
 */

#include <stddef.h>
#include <inttypes.h>
#include <stdlib.h>
#include <unistd.h>
#include <zlib.h>

#include "xg_private.h"
#include "xc_private.h"

#include <xen/config.h>
// #include <xen/foreign/x86_32.h>
// #include <xen/foreign/x86_64.h>
#include <public/hvm/hvm_info_table.h>
#include <public/xen.h>
#include <public/hvm/params.h>
//#include "xc_e820.h"

#include <stdio.h>
#include <public/libelf.h>
#include <public/version.h>

#include "hxen-host.h"

int
xc_set_hvm_param(int handle, domid_t dom, int param, unsigned long value)
{
    union hxen_hvmop_arg kha;

    memset(&kha, 0, sizeof(kha));
    kha.param.domid = 1/* dom */;
    kha.param.index = param;
    kha.param.value = value;

    return hxen_xc_hvmop(HVMOP_set_param, &kha);
}

int
xc_get_hvm_param(int handle, domid_t dom, int param, unsigned long *value)
{
    int rc;
    union hxen_hvmop_arg kha;

    memset(&kha, 0, sizeof(kha));
    kha.param.domid = 1/* dom */;
    kha.param.index = param;

    rc = hxen_xc_hvmop(HVMOP_get_param, &kha);
    *value = kha.param.value;
    return rc;
}

// Stolen from xc_misc.c
int
xc_hvm_set_isa_irq_level(int xc_handle, domid_t dom, uint8_t isa_irq,
			 unsigned int level)
{
    union hxen_hvmop_arg kha;

    memset(&kha, 0, sizeof(kha));
    kha.set_isa_irq_level.domid   = dom;
    kha.set_isa_irq_level.isa_irq = isa_irq;
    kha.set_isa_irq_level.level   = level;

    return hxen_xc_hvmop(HVMOP_set_isa_irq_level, &kha);
}

// Stolen from xc_misc.c
int
xc_hvm_set_pci_link_route(int xc_handle, domid_t dom, uint8_t link,
			  uint8_t isa_irq)
{
    union hxen_hvmop_arg kha;

    memset(&kha, 0, sizeof(kha));
    kha.set_pci_link_route.domid   = dom;
    kha.set_pci_link_route.link    = link;
    kha.set_pci_link_route.isa_irq = isa_irq;
    
    return hxen_xc_hvmop(HVMOP_set_pci_link_route, &kha);
}

// Stolen from xc_misc.c
int
xc_hvm_set_pci_intx_level(int xc_handle, domid_t dom, uint8_t domain,
			  uint8_t bus, uint8_t device, uint8_t intx,
			  unsigned int level)
{
    union hxen_hvmop_arg kha;

    memset(&kha, 0, sizeof(kha));
    kha.set_pci_intx_level.domid  = dom;
    kha.set_pci_intx_level.domain = domain;
    kha.set_pci_intx_level.bus    = bus;
    kha.set_pci_intx_level.device = device;
    kha.set_pci_intx_level.intx   = intx;
    kha.set_pci_intx_level.level  = level;

    return hxen_xc_hvmop(HVMOP_set_pci_intx_level, &kha);
}

int xc_hvm_track_dirty_vram_enabled = 1;
int
xc_hvm_track_dirty_vram(int xc_handle, domid_t dom, uint64_t first_pfn,
			uint64_t nr, unsigned long *dirty_bitmap)
{
#if 1
    union hxen_hvmop_arg kha;

    if (xc_hvm_track_dirty_vram_enabled == 0) {
	if (dirty_bitmap)
	    memset(dirty_bitmap, 0, nr / 8);
	return 0;
    }
    memset(&kha, 0, sizeof(kha));
    kha.track_dirty_vram.domid     = dom;
    kha.track_dirty_vram.first_pfn = first_pfn;
    kha.track_dirty_vram.nr        = nr;
    set_xen_guest_handle(kha.track_dirty_vram.dirty_bitmap,
			 (uint8_t *)dirty_bitmap);

    return hxen_xc_hvmop(HVMOP_track_dirty_vram, &kha);
#else
    if (dirty_bitmap)
	memset(dirty_bitmap, 0xff, nr / 8);
    return 0;
#endif
}

void *xc_map_foreign_pages(int xc_handle, uint32_t dom, int prot,
                           const xen_pfn_t *arr, int num)
{
    xen_pfn_t *pfn;
    void *res;
    int i;

    pfn = malloc(num * sizeof(*pfn));
    if (!pfn)
        return NULL;
    memcpy(pfn, arr, num * sizeof(*pfn));

    res = xc_map_foreign_batch(xc_handle, dom, prot, pfn, num);
    if (res) {
        for (i = 0; i < num; i++) {
            if ((pfn[i] & 0xF0000000UL) == 0xF0000000UL) {
                /*
                 * xc_map_foreign_batch() doesn't give us an error
                 * code, so we have to make one up.  May not be the
                 * appropriate one.
                 */
                errno = EINVAL;
                xc_munmap(res, num * PAGE_SIZE);
                res = NULL;
                break;
            }
        }
    }

    free(pfn);
    return res;
}
