/******************************************************************************
 * xc_private.c
 *
 * Helper functions for the rest of the library.
 */

#include <inttypes.h>
#include "xc_private.h"
#include "xg_private.h"
#include <stdarg.h>
// #include <pthread.h>

#include "hxen-host.h"

int xc_clear_domain_page(int xc_handle,
                         uint32_t domid,
                         unsigned long dst_pfn)
{
    void *vaddr = xc_map_foreign_range(
        xc_handle, domid, PAGE_SIZE, PROT_WRITE, dst_pfn);
    if ( vaddr == NULL )
        return -1;
    memset(vaddr, 0, PAGE_SIZE);
    xc_munmap(vaddr, PAGE_SIZE);
    return 0;
}

int xc_version(int xc_handle, int cmd, void *arg)
{
    int rc, argsize = 0;

    switch ( cmd )
    {
    case XENVER_extraversion:
        argsize = sizeof(xen_extraversion_t);
        break;
    case XENVER_compile_info:
        argsize = sizeof(xen_compile_info_t);
        break;
    case XENVER_capabilities:
        argsize = sizeof(xen_capabilities_info_t);
        break;
    case XENVER_changeset:
        argsize = sizeof(xen_changeset_info_t);
        break;
    case XENVER_platform_parameters:
        argsize = sizeof(xen_platform_parameters_t);
        break;
    }

#if 0
    if ( (argsize != 0) && (lock_pages(arg, argsize) != 0) )
    {
        PERROR("Could not lock memory for version hypercall");
        return -ENOMEM;
    }
#endif

#ifdef VALGRIND
    if (argsize != 0)
        memset(arg, 0, argsize);
#endif

#if 0
    rc = do_xen_version(xc_handle, cmd, arg);
#else
    rc = hxen_xc_version(cmd, arg);
#endif

#if 0
    if ( argsize != 0 )
        unlock_pages(arg, argsize);
#endif

    return rc;
}
