#include <stddef.h>
#include <inttypes.h>
#include <stdlib.h>
#include <unistd.h>

#include "xg_private.h"
#include "xc_private.h"

#include <hxen_info.h>

#include "hxen-host.h"

#include "cpu.h"

int xc_qemu_use_foreign_mappings = 0;

void *xc_map_foreign_batch(int xc_handle, uint32_t dom, int prot,
                           xen_pfn_t *arr, int num)
{

#if 1
    return hxen_xc_mmapbatch(arr, num, prot, domid);
#else
    return phys_addr_vmap(arr[0] << PAGE_SHIFT);
#endif
}

void *xc_map_foreign_range(int xc_handle, uint32_t dom,
                           int size, int prot,
                           unsigned long mfn)
{
#if 0
    xen_pfn_t *pfn;
#endif
    extern int domid;
    if (dom != domid) {
	errno = EINVAL;
	return NULL;
    }
#if 1
    if ((mfn >> KXEN_VMAPPING_SHIFT) !=
	((mfn + ((size - 1) >> PAGE_SHIFT)) >> KXEN_VMAPPING_SHIFT)) {
	errno = EINVAL;
	return NULL;
    }
    return phys_addr_vmap(mfn << PAGE_SHIFT);
#else
    num = size >> PAGE_SHIFT;
    pfn = malloc(num * sizeof(*pfn));
    if (!pfn)
	return NULL;
    res = hxen_xc_mmapbatch(pfn, num, prot, domid);
    free(pfn);
    return res;
#endif
}

void xc_munmap(void *addr, int size)
{
    if (xc_qemu_use_foreign_mappings)
	hxen_xc_munmap(addr, size >> PAGE_SHIFT);
}
