
#ifndef QEMU

#include <errno.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

#include <config-host.h>

#include "libvnc.h"

void *qemu_malloc(size_t size);
void *qemu_mallocz(size_t size);
void qemu_free(void *ptr);
char *qemu_strdup(const char *str);
void *qemu_realloc(void *ptr, size_t size);
void *qemu_reallocz(void *ptr, size_t size);
#define	vnc_mallocz(s) qemu_mallocz((s))
#define	vnc_free(p) qemu_free((p))

#ifndef VNCTERM_BIOS_DIR
#define	bios_dir CONFIG_QEMU_SHAREDIR
#else
#define	bios_dir VNCTERM_BIOS_DIR
#endif

#define	MIN(a,b) (((a)<(b))?(a):(b))

struct QEMUTimer {
};
typedef struct QEMUTimer QEMUTimer;

#else
#include "vl.h"
#define	vnc_mallocz(s) qemu_mallocz(s)
#define	vnc_free(p) qemu_free((p))
#endif

extern char vncpasswd[64];
extern unsigned char challenge[AUTHCHALLENGESIZE];

