#include "logging.h"

#ifndef _WIN32
void cpu_set_log_syslog(const char *ident)
{
    closelog();
    openlog(ident, LOG_NOWAIT | LOG_PID, LOG_DAEMON);
}

int __syslog_fprintf(FILE *stream, const char *format, ...)
{
    va_list ap;

    va_start(ap, format);
    vsyslog(LOG_DAEMON | LOG_NOTICE, format, ap);
    va_end(ap);

    return 0;
}
#endif
