#ifdef __MINIOS__
#define CONFIG_STUBDOM
#define NO_AIO 1
#define NO_UNIX_SOCKETS 1
#endif

#define DOMAIN_NAME_LEN 128
extern char domain_name[DOMAIN_NAME_LEN];
extern int domid;

#include <errno.h>

#ifdef bool
# define XEN_CONFIG_HOST_BOOL_WAS_DEFINED 1
#else
# define bool xen_bool
#endif

#include "xenctrl.h"
#include "xs.h"

#ifndef XEN_CONFIG_HOST_BOOL_WAS_DEFINED
# undef bool
#endif

#define BIOS_SIZE ((256 + 64) * 1024)

#undef CONFIG_GDBSTUB

void main_loop_prepare(void);

extern int xc_handle;
extern int xen_pause_requested;
extern int vcpus;

#define DEFAULT_NETWORK_SCRIPT "/etc/xen/qemu-ifup"
#define DEFAULT_NETWORK_DOWN_SCRIPT "/etc/xen/qemu-ifdown"

void xenstore_parse_domain_config(int domid);
void xenstore_read_vncpasswd(int domid, char *pwbuf, size_t pwbuflen);
void xenstore_dm_finished_startup(void);
unsigned int xenstore_get_cores_per_socket(int domid);

#ifdef CONFIG_STUBDOM
extern struct BlockDriver bdrv_vbd;
#endif
struct CharDriverState;
void xenstore_store_serial_port_info(int i, struct CharDriverState *chr,
				     const char *devname);
