CPPFLAGS+= -I$(XEN_ROOT)/tools/libxc
CPPFLAGS+= -I$(XEN_ROOT)/tools/xenstore
CPPFLAGS+= -I$(XEN_ROOT)/tools/include
CPPFLAGS+= -I$(SRC_PATH)/libvnc

SSE2 := $(call cc-option,-msse2,)
ifeq ($(SSE2),-msse2)
CFLAGS += -DUSE_SSE2=1 -msse2
endif

QEMU_PROG=qemu-dm

CPPFLAGS += -DQEMU_KXEN

CFLAGS += -Wno-unused -Wno-declaration-after-statement

ifndef CONFIG_WIN32
ifeq (,$(shell $(CC) -Wno-pointer-sign -E - </dev/null >/dev/null || echo x))
CFLAGS += -Wno-pointer-sign
endif 
endif

CFLAGS += $(CMDLINE_CFLAGS)

ifndef CONFIG_WIN32
LIBS += -L$(XEN_ROOT)/tools/libxc -lxenctrl -lxenguest
LIBS += -L$(XEN_ROOT)/tools/xenstore -lxenstore
endif
LIBS+=-L$(SRC_PATH)/libvnc -lvnc

LDFLAGS := $(CFLAGS) $(LDFLAGS)

OBJS += piix4acpi.o
OBJS += xenstore.o
OBJS += xen_platform.o
OBJS += crashdump.o
OBJS += xen_machine_fv.o
OBJS += xen_machine_pv.o
OBJS += xenfb.o
OBJS += xen_console.o
OBJS += xen_machine_fv.o
OBJS += exec-dm.o
OBJS += pci_emulation.o

ifdef CONFIG_WIN32
CPPFLAGS += -I$(SRC_PATH)/../hxen/include -I/include -I$(SRC_PATH) -I$(SRC_PATH)/i386-dm

TK2_OBJS = tenkei2-driver.o tenkei2.o
OBJS += $(TK2_OBJS)

$(TK2_OBJS) : CPPFLAGS += -I$(SRC_PATH)/../windows/inc

XC_OBJS=xc_hvm_build.o xc_misc.o xc_cpuid_x86.o xc_domain.o xc_private.o xg_private.o
OBJS += $(XC_OBJS)

LIBELF_PATH=$(SRC_PATH)/../common/libelf
LIBELF_OBJS=libelf-loader.o libelf-tools.o
OBJS += $(LIBELF_OBJS)

$(LIBELF_OBJS) : libelf-%.o : $(LIBELF_PATH)/libelf-%.c
	$(CC) $(CFLAGS) $(CPPFLAGS) -c -o $@ $<

BAD_OBJS += usb-linux.o
BAD_OBJS += xen_machine_pv.o xenfb.o xen_console.o

ifeq ($(HOST_USB), libusb)
LIBS+=$(LIBUSB_LIBS)
endif

LIBS+=-L/lib

BAD_OBJS += tpm_tis.o
endif

ifdef CONFIG_STUBDOM
CPPFLAGS += $(TARGET_CPPFLAGS)
CONFIG_SDL=
CONFIG_AUDIO=
OBJS += xenfbfront.o
else
OBJS += tpm_tis.o
endif

ifdef CONFIG_STUBDOM
CONFIG_PASSTHROUGH=1
else
  ifeq (,$(wildcard /usr/include/pci))
$(warning *** pciutils-dev package not found - missing /usr/include/pci)
$(warning *** PCI passthrough capability has been disabled)
  else
CONFIG_PASSTHROUGH=1
  endif
endif

ifdef CONFIG_PASSTHROUGH
OBJS+= pass-through.o pt-msi.o
LIBS += -lpci
CFLAGS += -DCONFIG_PASSTHROUGH 
$(info *** PCI passthrough capability has been enabled ***)
endif

BAD_OBJS += gdbstub.o acpi.o apic.o
BAD_OBJS += vmmouse.o vmport.o tcg* helper.o

OBJS := $(filter-out $(BAD_OBJS), $(OBJS))

EXESUF := -xen$(EXESUF)

datadir := $(subst qemu,xen/qemu,$(datadir))
docdir :=  $(subst qemu,xen/qemu,$(docdir))
mandir :=  $(subst share/man,share/xen/man,$(mandir))

configdir := /etc/xen
