
#include <err.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdint.h>
#include <sys/stat.h>

DECLARE_PROGNAME;

int
main(int argc, char **argv)
{
  int fd;
  char *empty1M;
  uint64_t size = 1, remaining;
  int arg;
  int blocksize = 1024 * 1024;
  int percent = 100;

  setprogname(argv[0]);

  if (argc < 3)
    errx(1, "usage: %s file size [size...]\n", argv[0]);

  empty1M = malloc(blocksize);
  if (empty1M == NULL)
    err(1, "malloc");

  for (arg = 2; arg < argc; arg++)
    size *= atoi(argv[arg]);

  fprintf(stderr, "creating %s with size %I64d\n", argv[1], size);

  fd = open(argv[1], O_CREAT | O_WRONLY | O_BINARY, S_IREAD | S_IWRITE);
  if (fd < 0)
    err(1, "open");

  remaining = size;
  while (remaining > 0) {
    int count;
    count = blocksize;
    if (count > remaining)
      count = remaining;
    count = write(fd, empty1M, count);
    remaining -= count;
    if (remaining < (size * percent / 100)) {
      while (remaining < (size * percent / 100))
	percent--;
      fprintf(stderr, "%d%% done -- remaining: %I64d\n", 100 - percent,
	      remaining);
    }
  }

  return 0;
}
