
#ifndef _KXEN_H_
#define _KXEN_H_

#include <stdarg.h>
#include <ntifs.h>
#include <ntddk.h>
#include <xen/types.h>

#include <hxen_info.h>

#define KERNEL 1

#ifdef DBG
#define KXEN_DPRINTK
#endif

#define	KXEN_DRIVER_VERSION_MAJOR	0x00000000
#define	KXEN_DRIVER_VERSION_MINOR	0x00000000
#define	KXEN_DRIVER_VERSION_TAG		"preview"

#define KXEN_DEVICE_NAME_U L"\\Device\\hxen"
#define KXEN_DEVICE_NAME_DOS_U L"\\DosDevices\\hxen"

#define KXEN_POOL_TAG 'hxen'

#if defined(__x86_64__)
#define MAX_MACHINE_FRAME 0x400000;
#else
#define MAX_MACHINE_FRAME 0x100000;
#endif

// Windows system clock increments in 100ns units, ie 10,000,000Hz.
#define KXEN_HOST_TIME_FREQUENCY 10000000

#define TIME_RELATIVE(x)         (-((int64_t)(x)))
#define TIME_NANO100_PER_MS      10000
#define TIME_NANO100_PER_NANO(x) ((x) / 100)
#define TIME_MS(x)               ((x) * TIME_NANO100_PER_MS)
#define TIME_NANO(x)             (TIME_NANO100_PER_NANO(x))

struct vm_info {
    struct vm_info_shared vi_shared;
    KTIMER vi_timer;
    KDPC vi_timer_dpc;
    unsigned long vi_host_cpu;
    KDPC vi_ipi_dpc;
};

struct device_extension {
    KSPIN_LOCK de_biglock;
    FAST_IO_DISPATCH de_FastIoDispatch;
    KEVENT de_runnable;
    int de_nrpages;
    struct vm_info de_vm_info;
    int de_nrmdls;
    MDL **de_mdls;
    KEVENT *de_ioemu_request_event;
    KEVENT *de_ioemu_completed_event;
};

/* hxen.c */
extern struct device_extension *hxen_devext;
extern uint8_t *hxen_hv;
extern size_t hxen_size;

/* hxen_call.c */
#define EEXCEPT 199
extern int hxen_try_call(long (__cdecl *)(void *), void *, void *);
extern void *__cdecl hxen_get_current(void);
extern void __cdecl hxen_set_current(void *);

/* hxen_cpu.c */
extern unsigned long hxen_cpu_vm;
extern unsigned long hxen_first_cpu(void);
extern void hxen_cpu_pin(unsigned long);
extern void hxen_cpu_pin_current(void);
extern void hxen_cpu_pin_first(void);
#define hxen_cpu_pin_dom0() hxen_cpu_pin_first()
extern void hxen_cpu_pin_vcpu(struct vm_info *);
extern void hxen_cpu_unpin(void);
extern void hxen_set_cpu_active_mask(void *, int);
extern void __cdecl hxen_on_each_cpu(void (*)(void *), void *);

/* hxen_ioctl.c */
extern BOOLEAN hxen_ioctl(__in FILE_OBJECT *, __in BOOLEAN, __in_opt VOID *,
			  __in ULONG, __out_opt VOID *, __in ULONG, __in ULONG,
			  __out IO_STATUS_BLOCK *, __in DEVICE_OBJECT *);

/* hxen_load.c */
int hxen_load(struct hxen_load_desc *);
int hxen_unload(void);

/* hxen_mem.c */
void *kernel_malloc(size_t);
void kernel_free(void *, size_t);
void *kernel_malloc_heap(uint32_t, uint32_t **);
void kernel_free_heap(void);
int hxen_mmapbatch(struct hxen_mmapbatch_desc *);
int hxen_munmap(struct hxen_munmap_desc *);
int hxen_create_vmappings(struct hxen_vmappings_desc *,
			  struct device_extension *);
void hxen_free_vmappings(struct device_extension *);
void * __cdecl hxen_map_pages(unsigned int, void *);
int __cdecl hxen_unmap_pages(unsigned int, void *);

/* hxen_ops.c */
int hxen_except_handler(unsigned int, struct _EXCEPTION_POINTERS *);
#define KXEN_EXCEPTION_EXECUTE_HANDLER \
    hxen_except_handler(GetExceptionCode(), GetExceptionInformation())
void hxen_init_free_allocs(void);
int hxen_init(void);
int hxen_shutdown(void);
int hxen_version(struct hxen_version_desc *);
int hxen_execute(void);
int hxen_keyhandler(char *, unsigned int);
int hxen_set_ioemu_events(struct hxen_ioemu_events_desc *,
			  struct device_extension *);

/* hxen_debug.c */
struct device_extension *kdbgdevext;
int kdbgprint;
extern int __cdecl hxen_dprintk(const char *, ...);
#ifdef KXEN_DPRINTK
#define dprintk(fmt, ...) hxen_dprintk(fmt, __VA_ARGS__)
#else
#define dprintk(fmt, ...) do {} while (0)
#endif
#define fail_msg(fmt, ...) hxen_printk("hxen: " fmt "\n", __VA_ARGS__)
extern int hxen_printk(const char *, ...);
extern void kdbgreboot(void);

static __inline int
ffs(uint32_t i)
{
    int m = 16;
    int b = 1;

    if (i == 0)
	return 0;
    while (m > 0) {
	if ((i & ((1 << m) - 1)) == 0) {
	    i >>= m;
	    b += m;
	}
	m >>= 1;
    }
    return b;
}

#endif
