
#include "hxen.h"
#include "hxen_call.h"
#include <hxen_ioctl.h>

#if !defined(USE_EXCEPTION_RECORD_HOOK)

// TODO: Add code to remove defunct vcpu threads.
#define KXEN_MAX_SUPPORTED_VCPUS 64
static struct _hxen_thread_to_vcpu {
    void * thread;
    void * vcpu;
} hxen_thread_to_vcpu[KXEN_MAX_SUPPORTED_VCPUS];

volatile long hxen_thread_cpu_high = 0;
long hxen_current_cache = 0;
KSPIN_LOCK hxen_current_table_lock;

extern void ud2(void);

static void * __cdecl
hxen_new_current(void * current)
{
    void * self = KeGetCurrentThread();
    long high;
    long i;
    KIRQL old_irql;

    if (!current)
        return NULL;

    KeAcquireSpinLock(&hxen_current_table_lock, &old_irql);
    high = hxen_thread_cpu_high;

    /* Find empty slot, if any */

    for (i = 0; i < high; i++)
    {
        if (!hxen_thread_to_vcpu[i].thread)
            break;
    }

    if (i == high)
        hxen_thread_cpu_high = high + 1;

    if (i >= KXEN_MAX_SUPPORTED_VCPUS) {
        dprintk("hxen thread_to_current table overflow.\n");
        ud2();
    }
    hxen_thread_to_vcpu[i].vcpu = current;
    hxen_thread_to_vcpu[i].thread = self;
    hxen_current_cache = i;

    KeReleaseSpinLock(&hxen_current_table_lock, old_irql);
    return NULL;
}
#endif

void __cdecl
hxen_set_current(void *current)
{
#if defined(USE_EXCEPTION_RECORD_HOOK)
    ((struct hxen_EXCEPTION_REGISTRATION_RECORD *)
     ((struct win_EXCEPTION_REGISTRATION_RECORD *)
      __readfsdword(0x0))->next)->current = current;
#else
    void * self = KeGetCurrentThread();
    long high = hxen_thread_cpu_high;
    long i;

    for (i = 0; i < high; i++) {
        if (hxen_thread_to_vcpu[i].thread == self) {
            if (!current) 
                hxen_thread_to_vcpu[i].thread = NULL;
            hxen_current_cache = i;
            hxen_thread_to_vcpu[i].vcpu = current;
            return;
        }
    }
    hxen_new_current(current);
#endif
}

#if !defined(USE_EXCEPTION_RECORD_HOOK)
void * __cdecl
hxen_swap_current(void *current)
{
    void * self = KeGetCurrentThread();
    long high = hxen_thread_cpu_high;
    long i;
    void * previous;

    for (i = 0; i < high; i++) {
        if (hxen_thread_to_vcpu[i].thread == self) {
            previous = hxen_thread_to_vcpu[i].vcpu;
            hxen_current_cache = i;
            hxen_thread_to_vcpu[i].vcpu = current;
            return previous;
        }
    }
    return hxen_new_current(current);
}
#endif

void * __cdecl
hxen_get_current(void)
{
#if defined(USE_EXCEPTION_RECORD_HOOK)
    return ((struct hxen_EXCEPTION_REGISTRATION_RECORD *)
            ((struct win_EXCEPTION_REGISTRATION_RECORD *)
             __readfsdword(0x0))->next)->current;
#else
    void * self = KeGetCurrentThread();
    long high = hxen_thread_cpu_high;
    long i;

    i = hxen_current_cache;
    if (hxen_thread_to_vcpu[i].thread == self)
        return hxen_thread_to_vcpu[i].vcpu;

    for (i = high - 1; i >= 0 ; i--) {
        if (hxen_thread_to_vcpu[i].thread == self) {
            if (!hxen_thread_to_vcpu[i].vcpu) {
                dprintk("hxen_get_current returning null!!\n");
                __debugbreak();
            }
            hxen_current_cache = i;
            return hxen_thread_to_vcpu[i].vcpu;
        }
    }
    /* BUG(); if we could but that's blob code. */
    dprintk("hxen_get_current, no value for this thread!!\n");
    ud2();
    return NULL;
#endif
}

int
hxen_try_call(long (__cdecl *fn)(void *), void *arg, void *current)
{
    int ret;
    DECLARE_EXCEPTION_REGISTRATION_RECORD(hxen_rec);

    HOOK_EXCEPTION_REGISTRATION_RECORD(hxen_rec, current);

    try {
	ret = fn(arg);
    } except (KXEN_EXCEPTION_EXECUTE_HANDLER) {
	fail_msg("hxen_try_call: %p(%p) exception: 0x%08X",
		 GetExceptionCode());
	ret = -EEXCEPT;
    }

#if defined(USE_EXCEPTION_RECORD_HOOK)
    UNHOOK_EXCEPTION_REGISTRATION_RECORD(hxen_rec);
#endif

    return ret;
}

