
struct win_EXCEPTION_REGISTRATION_RECORD {
    struct win_EXCEPTION_REGISTRATION_RECORD *next;
    void *handler;
};

struct hxen_EXCEPTION_REGISTRATION_RECORD {
    struct win_EXCEPTION_REGISTRATION_RECORD win_rec;
    void *current;
    char ident[4];
};

#if defined(__x86_64__)
#define ud2 _ud2
#endif

#if defined(USE_EXCEPTION_RECORD_HOOK)

#define DECLARE_EXCEPTION_REGISTRATION_RECORD(r)	\
    struct hxen_EXCEPTION_REGISTRATION_RECORD r;	\
    struct win_EXCEPTION_REGISTRATION_RECORD *win_##r;	\
    void ud2(void)

#define HOOK_EXCEPTION_REGISTRATION_RECORD(r, c) do {			\
	win_##r =							\
	    (struct win_EXCEPTION_REGISTRATION_RECORD *)__readfsdword(0x0); \
	r.current = c;							\
	r.win_rec.handler = (void *)ud2;				\
	r.win_rec.next = win_##r->next;					\
	memcpy(r.ident, "HXen", 4);					\
	win_##r->next = &r.win_rec;					\
    } while (0)

#define UNHOOK_EXCEPTION_REGISTRATION_RECORD(r) do {	\
	win_##r->next = r.win_rec.next;			\
    } while (0)

#else

#define DECLARE_EXCEPTION_REGISTRATION_RECORD(r)	\
    void * r;                                           \
    void ud2(void);                                     \
    void __cdecl hxen_set_current(void *);              \
    void * __cdecl hxen_swap_current(void *)

#define HOOK_EXCEPTION_REGISTRATION_RECORD(r, c)        \
        r = hxen_swap_current(c)

#define UNHOOK_EXCEPTION_REGISTRATION_RECORD(r)         \
        hxen_set_current(r)

#endif
