
#include <stdarg.h>

#include "hxen.h"

struct device_extension *kdbgdevext = NULL;

int kdbgprint = 1;

static int
hxen_vprintk(const char *fmt, va_list ap)
{
    int ret;

    if (kdbgprint == 0)
	return 0;
    ret = vDbgPrintEx(DPFLTR_IHVDRIVER_ID, DPFLTR_ERROR_LEVEL, fmt, ap);
    return ret;
}

#ifdef KXEN_DPRINTK
int __cdecl
hxen_dprintk(const char *fmt, ...)
{
    int ret;
    va_list ap;

    va_start(ap, fmt);
    ret = hxen_vprintk(fmt, ap);
    va_end(ap);

    return ret;
}
#else
int __cdecl
hxen_dprintk(const char *fmt, ...)
{
    return 0;
}
#endif

int
hxen_printk(const char *fmt, ...)
{
    int ret;
    va_list ap;

    va_start(ap, fmt);
#if 0
    /* XXX Some form of printk or event log? */
    ret = vprintf(fmt, ap);
#else
    ret = 0;
#endif
    hxen_vprintk(fmt, ap);
    va_end(ap);
    return ret;
}

#if defined(__x86_64__)
void kdbgrebootsup(void);
#else
void
ud2(void)
{
    __asm {
	ud2;
    }
}
#endif

int kdbgdoreboot = 0;
void
kdbgreboot(void)
{
    KeSetSystemAffinityThread(1 << 0);
#if defined(__x86_64__)
    kdbgrebootsup();
#else
    __asm {
	/* VMXOFF */
	_emit 0x0f;
	_emit 0x01;
	_emit 0xc4;
	push 0xffffffff;
	push 0xffff0000;
	lidt [esp];
	ud2;
    }
    ud2();
#endif
}
