
#ifndef _KXEN_IOCTL_H_
#define _KXEN_IOCTL_H_

#define KXEN_FLAG_INBUFFER 0x800
#define KXEN_FLAG_OUTBUFFER 0x400

#define KXEN_IO(nr)							\
    CTL_CODE(FILE_DEVICE_UNKNOWN, nr, METHOD_NEITHER, FILE_ANY_ACCESS)
#define KXEN_IOW(nr, size_ignored)		\
    KXEN_IO(nr | KXEN_FLAG_OUTBUFFER)
#define KXEN_IOR(nr, size_ignored)		\
    KXEN_IO(nr | KXEN_FLAG_INBUFFER)
#define KXEN_IOWR(nr, size_ignored)				\
    KXEN_IO(nr | KXEN_FLAG_OUTBUFFER | KXEN_FLAG_INBUFFER)

#define FUNCTION_FROM_CTL_CODE(ctl)		\
    ((ctl) >> 2 & 0xfff)

struct hxen_version_desc {
    uint32_t kvd_driver_version_major;
    uint32_t kvd_driver_version_minor;
    char kvd_driver_version_tag[32];
};

#include <hxen_desc.h>
#include <hxen_desc_sys.h>

struct hxen_load_desc {
    XEN_GUEST_HANDLE_64(uint8) kld_uvaddr;
    uint32_t kld_size;
};

#define	KXENVERSION		KXEN_IOW(1, struct hxen_version_desc)
#define	KXENLOAD		KXEN_IOR(2, struct hxen_load_desc)
#define	KXENUNLOAD		KXEN_IO(3)
#define	KXENINIT		KXEN_IO(4)
#define	KXENSHUTDOWN		KXEN_IO(5)
#define	KXENREBOOT		KXEN_IO(6)
#define	KXENKEYHANDLER		KXEN_IOR(7, char[])

#define	KXENHYPERCALL		KXEN_IOR(10, struct hxen_hypercall_desc)
#define	KXENMEMOP		KXEN_IOR(11, struct hxen_memop_desc)
#define	KXENHVMOP		KXEN_IOR(12, struct hxen_hvmop_desc)
#define	KXENDOMCTL		KXEN_IOR(13, xen_domctl_t)
#define	KXENMMAPBATCH		KXEN_IOR(14, struct hxen_mmapbatch_desc)
#define	KXENMUNMAP		KXEN_IOR(15, struct hxen_munmap_desc)
#define	KXENVMAPPINGS		KXEN_IOR(16, struct hxen_vmappings_desc)
#define	KXENEXECUTE		KXEN_IO(17)
#define	KXENSETIOEMUEVENTS	KXEN_IOR(18, struct hxen_ioemu_events_desc)

#endif
