//
// hvm.h - Exports and prototypes for communicating with the xen
//         hypervisor.
//
// Copyright (c) 2006 XenSource, Inc. - All rights reserved.
//
#ifndef _HVM_H_
#define _HVM_H_

#include "ntddk.h"
#include "xenhdrs/xen.h"

extern shared_info_t *HYPERVISOR_shared_info;
extern int HvmInterruptNumber;
extern USHORT unplug_protocol;

//
// Function prototypes.
//
NTSTATUS
InitHvm(void);

VOID
CleanupHvm(
       VOID
);

int
AddPageToPhysmap(unsigned long pfn,
         unsigned space,
         unsigned long offset);

ULONG_PTR
HvmGetParameter(int param_nr);

ULONG_PTR _readcr3(VOID);

VOID _wrmsr(uint32_t msr, uint32_t lowbits, uint32_t highbits);

void UnquiesceSystem(KIRQL OldIrql);
KIRQL QuiesceSystem(VOID);

VOID KillSuspendThread(VOID);
VOID SuspendPreInit(VOID);

int HvmSetCallbackIrq(int irq);

#ifndef AMD64
/* Force a processor pipeline flush, so that self-modifying code
   becomes safe to run. */
#define FLUSH_PIPELINE() _asm { cpuid }
#else
/* AMD64 -> no binary patches -> FLUSH_PIPELINE is a no-op */
#define FLUSH_PIPELINE() do {} while (0)
#endif

#endif /* _HVM_H_ */

