//
// hypercall.h
//
// Windows interface to the xen hypervisor.
//
// Copyright (c) 2006 XenSource, Inc.
//

#ifndef __HYPERCALL_H__
#include "xenhdrs/xen.h"

typedef char hypercall_trap_gate[32];

#ifdef AMD64
extern ULONG_PTR __hypercall2(unsigned long ordinal,
                              ULONG_PTR arg1,
                              ULONG_PTR arg2);
#else
extern hypercall_trap_gate *hypercall_page;

__declspec(inline) ULONG_PTR
__hypercall2(
    unsigned long ordinal,
    ULONG_PTR arg1,
    ULONG_PTR arg2)
{
    ULONG_PTR retval;
    ULONG_PTR addr = (ULONG_PTR)&hypercall_page[ordinal];

    _asm
    {
        mov ecx, arg2;
        mov ebx, arg1;
        mov eax, addr;
        call eax;
        mov retval, eax;
    }
    return retval;
}
#endif

#define _hypercall2(type, name, arg1, arg2) \
    ((type)__hypercall2(__HYPERVISOR_##name, (ULONG_PTR)arg1, (ULONG_PTR)arg2))

__declspec(inline) int
HYPERVISOR_event_channel_op(int cmd, void *op)
{
    return _hypercall2(int, event_channel_op, cmd, op);
}

__declspec(inline) int
HYPERVISOR_sched_op(
    int cmd, void *arg)
{
    return _hypercall2(int, sched_op, cmd, arg);
}

_declspec(inline) ULONG_PTR
HYPERVISOR_hvm_op(
    int op, void *arg)
{
    return _hypercall2(ULONG_PTR, hvm_op, op, arg);
}

_declspec(inline) int
HYPERVISOR_memory_op(
    unsigned int cmd, void *arg)
{
    return _hypercall2(int, memory_op, cmd, arg);
}

#endif /* __HYPERCALL_H__ */
