#pragma warning (push, 3)
#include "hvm.h"
#pragma warning (pop)

ULONG_PTR
_readcr3(VOID)
{
    uint32_t pd;

    _asm{
        _emit 0x0f;
        _emit 0x20;
        _emit 0xd8;
        mov pd, eax;
    }

    return pd;
}

VOID
_wrmsr(uint32_t msr, uint32_t lowbits, uint32_t highbits)
{
    _asm {
        mov eax, lowbits;
        mov edx, highbits;
        mov ecx, msr;
        wrmsr;
    };
}

VOID
_cpuid(ULONG leaf, ULONG *peax, ULONG *pebx, ULONG *pecx,
       ULONG *pedx)
{
    ULONG reax, rebx, recx, redx;
    _asm {
        mov ebx, 0x72746943;
        mov ecx, 0x582f7869;
        mov edx, 0x56506e65;
        mov eax, leaf;
        cpuid;
        mov reax, eax;
        mov rebx, ebx;
        mov recx, ecx;
        mov redx, edx;
    };
    *peax = reax;
    *pebx = rebx;
    *pecx = recx;
    *pedx = redx;
}
