#ifndef HVM_DMPAGE_H__
#define HVM_DMPAGE_H__

struct hvm_dmpage_pit_channel {
    int     count;
    int     pad;
    int64_t count_load_time;
};

/* Structure describing various bits of state maintained by the
   hypervisor device model which are exposed to guests.  These can
   sometimes be used by PV drivers to avoid trapping into the
   hypervisor from hot paths. */
struct hvm_dmpage {
    int version; /* 0 for now */
    int pad;
    /* i8254 PIT stuff */
    int64_t tsc_frequency;
    struct hvm_dmpage_pit_channel pit_channels[3];
};

#endif /* HVM_DMPAGE_H__ */
