#define HVM_NR_PARAMS 9

#define HVM_PARAM_CALLBACK_IRQ 0
#define HVM_PARAM_STORE_PFN    1
#define HVM_PARAM_STORE_EVTCHN 2
#define HVM_PARAM_APIC_ENABLED 3
#define HVM_PARAM_32BIT 8

#define HVMOP_set_param 0
#define HVMOP_get_param 1

struct xen_hvm_param {
    domid_t domid;
    unsigned index;
    ULONGLONG value;
};
typedef struct xen_hvm_param xen_hvm_param_t;

/* Get the current Xen time, in nanoseconds since system boot. */
#define HVMOP_get_time_compat            6
#define HVMOP_get_time                   0x101
struct xen_hvm_get_time {
    ULONGLONG now;      /* OUT */
};
typedef struct xen_hvm_get_time xen_hvm_get_time_t;

/* Provides CR3 for a process being destroyed inside the HVM */
#define HVMOP_process_destroy_compat     7
#define HVMOP_process_destroy            0x102
struct xen_hvm_process_destroy {
    ULONG_PTR cr3;
};
typedef struct xen_hvm_process_destroy xen_hvm_process_destroy_t;

//
// Allows PV drivers to inject performance tracing.
//
#define HVMOP_xentrace              0x100

#define HVM_EVENT_PROCESS_CREATE    1
//
// First extra element is a void *
// Second extra element is the int
//

#define HVM_EVENT_IMAGE_LOAD        2
//
// First extra element is a void *
// Remaining extra bytes is ANSI process name.
//

struct xen_hvm_xentrace {
    uint16_t event, extra_bytes;
    uint8_t extra[28];
};
typedef struct xen_hvm_xentrace xen_hvm_xentrace_t;


#define HVMOP_set_driver_version 0x103
struct xen_hvm_set_driver_version {
    uint32_t build;
};
typedef struct xen_hvm_set_driver_version xen_hvm_set_driver_version_t;
