/* Various typedefs and so forth to make it a bit easier to use the
   Xen headers in a Windows environment. */
#ifndef WIN_XEN_TYPES_H__
#define WIN_XEN_TYPES_H__

#define DEFINE_XEN_GUEST_HANDLE(name) \
    typedef struct { name *p; } __guest_handle_ ## name

#define XEN_GUEST_HANDLE(name)          __guest_handle_ ## name
#define set_xen_guest_handle(hnd, val)  do { (hnd).p = val; } while (0)

typedef ULONG_PTR   xen_ulong_t;
typedef xen_ulong_t xen_pfn_t;

DEFINE_XEN_GUEST_HANDLE(xen_pfn_t);

#endif /* !WIN_XEN_TYPES_H__ */
