//
// xs_ioctl.h
//
// Copyright (c) 2006 XenSource, Inc. - All rights reserved.
//

#ifndef _XS_IOCTL_H_
#define _XS_IOCTL_H_

#pragma warning (disable: 4200) // nonstandard extension used : zero-sized array

#define IOCTL_XS_TRANS_START \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_TRANS_END \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x801, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_READ \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x802, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_WRITE \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x803, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_DIRECTORY \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x804, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_REMOVE \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x805, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_WATCH \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x806, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_UNWATCH \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x807, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_ENABLE_UNINST \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x808, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_SET_LOGLEVEL \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x809, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_LISTEN_SUSPEND \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80a, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_UNLISTEN_SUSPEND \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80b, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_GET_XEN_TIME \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80c, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_GET_LOG_SIZE \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80d, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_GET_LOG \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80e, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_MAKE_PRECIOUS \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80f, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_UNMAKE_PRECIOUS \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x810, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_LOG \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x811, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_VOLATILE_LISTEN \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x812, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_VOLATILE_GETMSG \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x813, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_VOLATILE_CLOSE \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x814, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_XS_QUERY_BALLOON \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x815, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define INITIAL_OUTBUF_SIZE 128

typedef struct {
    int len;
    char data[0]; // for write msg, it will contains the string path and data
} XS_READ_MSG, XS_WRITE_MSG;

typedef struct {
    int count;
    int len;
    char data[0];
} XS_DIR_MSG;

typedef struct {
    HANDLE event;
    char path[0];
} XS_WATCH_MSG;

typedef struct {
    HANDLE handle;
} XS_LISTEN_SUSPEND_MSG;


typedef struct {
    int dispositions[7];
} XS_LOGLEVEL_MSG;

typedef struct {
    unsigned backlog;
    HANDLE event;
    char port_name[0];
} XS_VOLATILE_LISTEN_IN;

typedef struct {
    unsigned handle;
} XS_VOLATILE_LISTEN_OUT;

typedef struct {
    unsigned handle;
    unsigned source_len;
    unsigned message_len;
    unsigned char payload[0]; /* The source followed by the message */
} XS_VOLATILE_RECV_MESSAGE;

typedef struct {
    unsigned handle;
} XS_VOLATILE_CLOSE;

typedef struct {
    unsigned max_pages;
    unsigned current_pages;
    unsigned target_pages;
    unsigned allocations_failed;
    unsigned partial_allocations;
    BOOLEAN running;
    BOOLEAN shutdown_requested;
    BOOLEAN timer_fired;
    BOOLEAN timer_inserted;
    BOOLEAN watch_fired;
} XS_QUERY_BALLOON;

#endif // _XS_IOCTL_H_
