/* Shims which make it easier to work with a bunch of different DDKs */
#ifndef XSCOMPAT_H__
#define XSCOMPAT_H__

/* An actual Linux- or Xen-style memory barrier.  Inhibits both
   compiler and processor reorderings. */
__declspec(inline)
VOID
XsMemoryBarrier(void)
{
    KeMemoryBarrier();
    _ReadWriteBarrier();
}

/* Likewise for reads */
__declspec(inline)
VOID
XsReadMemoryBarrier(void)
{
    _mm_lfence();
    _ReadBarrier();
}

/* And for writes */
__declspec(inline)
VOID
XsWriteMemoryBarrier(void)
{
    /* x86 already guarantees not to re-order writes, so don't need a
       processor barrier here.  Still need the compiler barrier,
       though. */
    _WriteBarrier();
}

#endif /* !XSCOMPAT_H__ */
