/* Copyright (C) 2007-2008 Google, Inc.
**
** This software is licensed under the terms of the GNU General Public
** License version 2, as published by the Free Software Foundation, and
** may be copied, distributed, and modified under those terms.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
*/
#include "android_charmap.h"

/* the following is automatically generated by the 'gen-charmap.py' script
 * do not touch. the generation command was:
 *   gen-charmap.py qwerty.kcm qwerty2.kcm
 */

static const AKeyEntry  _qwerty_keys[] =
{
   /* keycode                   base   caps    fn  caps+fn   number */

    { kKeyCodeA             ,   'a',   'A',   '#',   0x00,   '#' },
    { kKeyCodeB             ,   'b',   'B',   '<',   0x00,   '<' },
    { kKeyCodeC             ,   'c',   'C',   '9', 0x00E7,   '9' },
    { kKeyCodeD             ,   'd',   'D',   '5',   0x00,   '5' },
    { kKeyCodeE             ,   'e',   'E',   '2', 0x0301,   '2' },
    { kKeyCodeF             ,   'f',   'F',   '6', 0x00A5,   '6' },
    { kKeyCodeG             ,   'g',   'G',   '-',    '_',   '-' },
    { kKeyCodeH             ,   'h',   'H',   '[',    '{',   '[' },
    { kKeyCodeI             ,   'i',   'I',   '$', 0x0302,   '$' },
    { kKeyCodeJ             ,   'j',   'J',   ']',    '}',   ']' },
    { kKeyCodeK             ,   'k',   'K',   '"',    '~',   '"' },
    { kKeyCodeL             ,   'l',   'L',  '\'',    '`',  '\'' },
    { kKeyCodeM             ,   'm',   'M',   '!',   0x00,   '!' },
    { kKeyCodeN             ,   'n',   'N',   '>', 0x0303,   '>' },
    { kKeyCodeO             ,   'o',   'O',   '(',   0x00,   '(' },
    { kKeyCodeP             ,   'p',   'P',   ')',   0x00,   ')' },
    { kKeyCodeQ             ,   'q',   'Q',   '*', 0x0300,   '*' },
    { kKeyCodeR             ,   'r',   'R',   '3', 0x20AC,   '3' },
    { kKeyCodeS             ,   's',   'S',   '4', 0x00DF,   '4' },
    { kKeyCodeT             ,   't',   'T',   '+', 0x00A3,   '+' },
    { kKeyCodeU             ,   'u',   'U',   '&', 0x0308,   '&' },
    { kKeyCodeV             ,   'v',   'V',   '=',    '^',   '=' },
    { kKeyCodeW             ,   'w',   'W',   '1',   0x00,   '1' },
    { kKeyCodeX             ,   'x',   'X',   '8',   0x00,   '8' },
    { kKeyCodeY             ,   'y',   'Y',   '%', 0x00A1,   '%' },
    { kKeyCodeZ             ,   'z',   'Z',   '7',   0x00,   '7' },
    { kKeyCodeComma         ,   ',',   ';',   ';',    '|',   ',' },
    { kKeyCodePeriod        ,   '.',   ':',   ':', 0x2026,   '.' },
    { kKeyCodeAt            ,   '@',   '0',   '0', 0x2022,   '0' },
    { kKeyCodeSlash         ,   '/',   '?',   '?',   '\\',   '/' },
    { kKeyCodeSpace         ,  0x20,  0x20,   0x9,    0x9,  0x20 },
    { kKeyCodeNewline       ,   0xa,   0xa,   0xa,    0xa,   0xa },
    { kKeyCodeTab           ,   0x9,   0x9,   0x9,    0x9,   0x9 },
    { kKeyCode0             ,   '0',   ')',   '0',    ')',   '0' },
    { kKeyCode1             ,   '1',   '!',   '1',    '!',   '1' },
    { kKeyCode2             ,   '2',   '@',   '2',    '@',   '2' },
    { kKeyCode3             ,   '3',   '#',   '3',    '#',   '3' },
    { kKeyCode4             ,   '4',   '$',   '4',    '$',   '4' },
    { kKeyCode5             ,   '5',   '%',   '5',    '%',   '5' },
    { kKeyCode6             ,   '6',   '^',   '6',    '^',   '6' },
    { kKeyCode7             ,   '7',   '&',   '7',    '&',   '7' },
    { kKeyCode8             ,   '8',   '*',   '8',    '*',   '8' },
    { kKeyCode9             ,   '9',   '(',   '9',    '(',   '9' },
    { kKeyCodeGrave         ,   '`',   '~',   '`',    '~',   '`' },
    { kKeyCodeMinus         ,   '-',   '_',   '-',    '_',   '-' },
    { kKeyCodeEquals        ,   '=',   '+',   '=',    '+',   '=' },
    { kKeyCodeLeftBracket   ,   '[',   '{',   '[',    '{',   '[' },
    { kKeyCodeRightBracket  ,   ']',   '}',   ']',    '}',   ']' },
    { kKeyCodeBackslash     ,  '\\',   '|',  '\\',    '|',  '\\' },
    { kKeyCodeSemicolon     ,   ';',   ':',   ';',    ':',   ';' },
    { kKeyCodeApostrophe    ,  '\'',   '"',  '\'',    '"',  '\'' },
};

static const AKeyCharmap  _qwerty_charmap =
{
    _qwerty_keys,
    51,
    "qwerty"
};

static const AKeyEntry  _qwerty2_keys[] =
{
   /* keycode                   base   caps    fn  caps+fn   number */

    { kKeyCodeA             ,   'a',   'A',   'a',    'A',   'a' },
    { kKeyCodeB             ,   'b',   'B',   'b',    'B',   'b' },
    { kKeyCodeC             ,   'c',   'C', 0x00e7, 0x00E7,   'c' },
    { kKeyCodeD             ,   'd',   'D',  '\'',   '\'',  '\'' },
    { kKeyCodeE             ,   'e',   'E',   '"', 0x0301,   '"' },
    { kKeyCodeF             ,   'f',   'F',   '[',    '[',   '[' },
    { kKeyCodeG             ,   'g',   'G',   ']',    ']',   ']' },
    { kKeyCodeH             ,   'h',   'H',   '<',    '<',   '<' },
    { kKeyCodeI             ,   'i',   'I',   '-', 0x0302,   '-' },
    { kKeyCodeJ             ,   'j',   'J',   '>',    '>',   '>' },
    { kKeyCodeK             ,   'k',   'K',   ';',    '~',   ';' },
    { kKeyCodeL             ,   'l',   'L',   ':',    '`',   ':' },
    { kKeyCodeM             ,   'm',   'M',   '%',   0x00,   '%' },
    { kKeyCodeN             ,   'n',   'N',  0x00, 0x0303,   'n' },
    { kKeyCodeO             ,   'o',   'O',   '+',    '+',   '+' },
    { kKeyCodeP             ,   'p',   'P',   '=', 0x00A5,   '=' },
    { kKeyCodeQ             ,   'q',   'Q',   '|', 0x0300,   '|' },
    { kKeyCodeR             ,   'r',   'R',   '`', 0x20AC,   '`' },
    { kKeyCodeS             ,   's',   'S',  '\\', 0x00DF,  '\\' },
    { kKeyCodeT             ,   't',   'T',   '{', 0x00A3,   '}' },
    { kKeyCodeU             ,   'u',   'U',   '_', 0x0308,   '_' },
    { kKeyCodeV             ,   'v',   'V',   'v',    'V',   'v' },
    { kKeyCodeW             ,   'w',   'W',   '~',    '~',   '~' },
    { kKeyCodeX             ,   'x',   'X',   'x',    'X',   'x' },
    { kKeyCodeY             ,   'y',   'Y',   '}', 0x00A1,   '}' },
    { kKeyCodeZ             ,   'z',   'Z',   'z',    'Z',   'z' },
    { kKeyCodeComma         ,   ',',   '<',   ',',    ',',   ',' },
    { kKeyCodePeriod        ,   '.',   '>',   '.', 0x2026,   '.' },
    { kKeyCodeAt            ,   '@',   '@',   '@', 0x2022,   '@' },
    { kKeyCodeSlash         ,   '/',   '?',   '?',    '?',   '/' },
    { kKeyCodeSpace         ,  0x20,  0x20,   0x9,    0x9,  0x20 },
    { kKeyCodeNewline       ,   0xa,   0xa,   0xa,    0xa,   0xa },
    { kKeyCode0             ,   '0',   ')',   ')',    ')',   '0' },
    { kKeyCode1             ,   '1',   '!',   '!',    '!',   '1' },
    { kKeyCode2             ,   '2',   '@',   '@',    '@',   '2' },
    { kKeyCode3             ,   '3',   '#',   '#',    '#',   '3' },
    { kKeyCode4             ,   '4',   '$',   '$',    '$',   '4' },
    { kKeyCode5             ,   '5',   '%',   '%',    '%',   '5' },
    { kKeyCode6             ,   '6',   '^',   '^',    '^',   '6' },
    { kKeyCode7             ,   '7',   '&',   '&',    '&',   '7' },
    { kKeyCode8             ,   '8',   '*',   '*',    '*',   '8' },
    { kKeyCode9             ,   '9',   '(',   '(',    '(',   '9' },
    { kKeyCodeTab           ,   0x9,   0x9,   0x9,    0x9,   0x9 },
    { kKeyCodeGrave         ,   '`',   '~',   '`',    '~',   '`' },
    { kKeyCodeMinus         ,   '-',   '_',   '-',    '_',   '-' },
    { kKeyCodeEquals        ,   '=',   '+',   '=',    '+',   '=' },
    { kKeyCodeLeftBracket   ,   '[',   '{',   '[',    '{',   '[' },
    { kKeyCodeRightBracket  ,   ']',   '}',   ']',    '}',   ']' },
    { kKeyCodeBackslash     ,  '\\',   '|',  '\\',    '|',  '\\' },
    { kKeyCodeSemicolon     ,   ';',   ':',   ';',    ':',   ';' },
    { kKeyCodeApostrophe    ,  '\'',   '"',  '\'',    '"',  '\'' },
};

static const AKeyCharmap  _qwerty2_charmap =
{
    _qwerty2_keys,
    51,
    "qwerty2"
};

const AKeyCharmap*  android_charmaps[2] = { &_qwerty_charmap , &_qwerty2_charmap };
const int           android_charmap_count = 2;
