/* Copyright (C) 2007-2008 Google, Inc.
**
** This software is licensed under the terms of the GNU General Public
** License version 2, as published by the Free Software Foundation, and
** may be copied, distributed, and modified under those terms.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
*/
#ifndef PLATFORM_DEVICE_H
#define PLATFORM_DEVICE_H

struct platform_device {
    struct platform_device *next;
    struct platform_device *prev;
    uint32_t reported_state;
    void *cookie;
    const char *name;
    uint32_t id;
    uint32_t base; // filled in by platform_device_add if 0
    uint32_t size;
    uint32_t irq; // filled in by platform_device_add if 0
    uint32_t irq_count;
};


void platform_device_set_irq(struct platform_device *dev, int irq, int level);
int platform_device_add(struct platform_device *dev,
                       CPUReadMemoryFunc **mem_read,
                       CPUWriteMemoryFunc **mem_write,
                       void *opaque);

int platform_add_device_no_io(struct platform_device *dev);

void platform_device_init(void *pic, uint32_t base, uint32_t size, uint32_t irq, uint32_t irq_count);
int platform_device_bus_init(uint32_t base, uint32_t irq);

// device init functions:
void *platform_interrupt_init(uint32_t base, void *parent, int parent_irq, int parent_fiq);
void platform_timer_and_rtc_init(uint32_t timerbase, int timerirq);
int platform_tty_add(CharDriverState *cs, int id, uint32_t base, int irq);
void platform_fb_init(DisplayState *ds, int id);
void platform_audio_init(uint32_t base, int id, const char* input_source);
void platform_battery_init();
void platform_battery_set_prop(int ac, int property, int value);
void platform_battery_display(void (* callback)(void *data, const char* string), void *data);
void platform_mmc_init(uint32_t base, int id, BlockDriverState* bs);
void *platform_switch_add(char *name, uint32_t (*writefn)(void *opaque, uint32_t state), void *writeopaque, int id);
void platform_switch_set_state(void *opaque, uint32_t state);

// these do not add a device
void trace_dev_init(uint32_t base);
void events_dev_init(uint32_t base, void *pic, int irq);
void nand_dev_init(uint32_t base);

#endif
