/*
 * arch/arm/mach-imx21/imx21ads.c
 *
 * Initially based on:
 *	linux-2.6.7-imx/arch/arm/ mach-imx /scb9328.c
 *	Copyright (c) 2004 Sascha Hauer <sascha@saschahauer.de>
 *
 * 2004 (c) MontaVista Software, Inc.
 *
 * Modified By: Ron Melvin (ron.melvin@timesys.com)
 * Copyright (c) 2005 TimeSys Corporation 
 *
 * This file is licensed under the terms of the GNU General Public
 * License version 2. This program is licensed "as is" without any
 * warranty of any kind, whether express or implied.
 */

#include <linux/device.h>
#include <linux/init.h>
#include <linux/platform_device.h>
#include <asm/system.h>
#include <asm/hardware.h>
#include <asm/irq.h>
#include <asm/pgtable.h>
#include <asm/page.h>

#include <asm/mach/map.h>
#include <asm/mach-types.h>

#include <asm/mach/arch.h>
#include <linux/interrupt.h>
#include "generic.h"
#include <asm/serial.h>
#include <asm/setup.h>


#if defined (CONFIG_USB_IMX21_HCD)
#include <asm/arch/imx21-hcd.h>
#define OTG_TXCVR_VENDOR_ID_REG0                0x00
#define OTG_TXCVR_VENDOR_ID_REG1                0x01
#define OTG_TXCVR_PRODUCT_ID_REG0               0x02
#define OTG_TXCVR_PRODUCT_ID_REG1               0x03
#define OTG_TXCVR_MODE_REG1_SET                 0x04
#define OTG_TXCVR_MODE_REG1_CLR                 0x05
#define OTG_TXCVR_CTRL_REG1_SET                 0x06
#define OTG_TXCVR_CTRL_REG1_CLR                 0x07
#define OTG_TXCVR_INT_SRC_REG                   0x08
#define OTG_TXCVR_INT_LAT_REG_SET               0x0a
#define OTG_TXCVR_INT_LAT_REG_CLR               0x0b
#define OTG_TXCVR_INT_FALSE_REG_SET             0x0c
#define OTG_TXCVR_INT_FALSE_REG_CLR             0x0d
#define OTG_TXCVR_INT_TRUE_REG_SET              0x0e
#define OTG_TXCVR_INT_TRUE_REG_CLR              0x0f
#define OTG_TXCVR_CTRL_REG2_SET                 0x10
//#define OTG_TXCVR_CTRL_REG2_CLR                 0x11
#define OTG_TXCVR_MODE_REG2_SET                 0x12
#define OTG_TXCVR_MODE_REG2_CLR                 0x13
#define OTG_TXCVR_BCD_DEV_REG0                  0x14
#define OTG_TXCVR_BCD_DEV_REG1                  0x15

#define OTG_TXCVR_DEV_WRITE_ADDR 0x2D
#define OTG_TXCVR_DEV_READ_ADDR (0x2D | (1<<7))

#define ISP1301_ID_GROUNDED  (1<<3)
#endif

#if defined (CONFIG_FB_IMX)
 #include <asm/arch/imxfb.h>
 
 static struct imxfb_mach_info imx21ads_fb_info __initdata = {
     .pixclock     = 62500,
     .bpp          = 16,
     .xres         = 240,
     .yres         = 320,
     .hsync_len    = 1,
     .vsync_len    = 1,
     .left_margin  = 15,
     .upper_margin = 9,
     .right_margin = 6,
     .lower_margin = 7,
     
     .pcr = (PCR_COLOR    | 
             PCR_TFT      | 
             PCR_PBSIZ_8  |
	     PCR_BPIX_16  |
 	     PCR_PIXPOL   |
 	     PCR_OEPOL    |
 //	     PCR_ACD_SEL  |	
             PCR_SCLK_SEL |
 	     PCR_SHARP    |
             PCR_PCD(7)),
 /*  .pwmr     = PWMR_SCR0 | PWMR_CC_EN | PWMR_PW(0x70), */
     .pwmr       = 0x00a9037f, /* default value */
     .lscr1      = 0x00120300, /* reset default */
};
 
#endif /* defined(CONFIG_FB_IMX) */
 
#if defined(CONFIG_CIRRUS)
static struct resource cs8900_resources[] = {
    [0] = {
        .start  = MX2ADS_ETH_PHYS,
        .end    = MX2ADS_ETH_PHYS + MX2ADS_ETH_SIZE - 1,
        .flags  = IORESOURCE_MEM,
    },
    [1] = {
        .start  = MX2ADS_ETH_IRQ,
        .end    = MX2ADS_ETH_IRQ,
        .flags  = IORESOURCE_IRQ,
    },
};

static struct platform_device cs8900_device = {
    .name            = "cs8900",
    .id              = 0,
    .num_resources   = ARRAY_SIZE(cs8900_resources),
    .resource        = cs8900_resources,
};
#endif /* defined(CONFIG_CIRRUS) */

/* TODO, figure out correct IRQ */
static struct resource cpuvers_resources[] = {
	[0] = {
		.start	= IMX_CS1_VIRT+0x400000,
		.end	= IMX_CS1_VIRT+0x400000 + 2,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.start	= 0,
		.end	= 0,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device cpuvers_device = {
	.name		= "imx21-cpuvers",
	.num_resources	= ARRAY_SIZE(cpuvers_resources),
	.resource	= cpuvers_resources,
};

/* TODO, figure out correct IRQ */
static struct resource mx21cfg_resources[] = {
	[0] = {
		.start	= IMX_CS1_VIRT+0x800000,
		.end	= IMX_CS1_VIRT+0x800000 + 2,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.start	= 0,
		.end	= 0,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device mx21cfg_device = {
	.name		= "imx21-mx21cfg",
	.num_resources	= ARRAY_SIZE(mx21cfg_resources),
	.resource	= mx21cfg_resources,
};

#if defined(CONFIG_USB_IMX21_HCD)
static struct imx21_usb_platform_data csb535_usb_pdata = {
	.set_mode     = NULL,
	.set_speed    = NULL,
	.set_suspend  = NULL,
	.set_oe       = NULL,
};

static struct resource imx21_hc_resources[] = {
	[0] = {
		.start	= 0x10024000,
		.end	= 0x10025fff,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.start	= INT_USBHOST,
		.end	= INT_USBHOST,
		.flags	= IORESOURCE_IRQ,
	},
};

static u64 imx21_usb_dmamask = 0xffffffffUL;
static struct platform_device mx21_usb_hc_device = {
	.id   		= 0,
	.name 		= "imx21-hcd",
	.num_resources	= ARRAY_SIZE(imx21_hc_resources),
	.resource	= imx21_hc_resources,
	.dev  		= {
//		.platform_data = &platform_data;
//		.dma_mask = &imx21_usb_dmamask,
		.platform_data = &csb535_usb_pdata,
		.coherent_dma_mask = 0xffffffff,
	}
};
#endif

static struct platform_device *devices[] __initdata = {
#if defined(CONFIG_CIRRUS)
	&cs8900_device,
#endif
	&cpuvers_device,
	&mx21cfg_device,
#if defined(CONFIG_USB_IMX21_HCD)
	&mx21_usb_hc_device,
#endif
};

#if defined(CONFIG_USB_IMX21_HCD)
static int otg_i2c_wait_busy(void)
{
	unsigned long timeout;
	int cnt = 0;

	timeout = jiffies + HZ;

	while (USBOTG_I2C_OP_CTRL_REG & 0x80) {
		if (time_after(jiffies, timeout)) {
			return -ETIMEDOUT;
		}
		cnt++;
		if (!in_interrupt())
			schedule_timeout(1);

	}
	
	return 0;
}

static int otg_i2c_reg_write(u8 reg, u8 data)
{
	USBOTG_I2C_TXCVR_REG(reg) = data;
	
	/* set sequential read start address */
	USBOTG_I2C_SEQ_RD_STARTAD = reg;
	
	/* set number of sequential operations */
	USBOTG_I2C_SEQ_OP_REG = 1;

	/* set transceiver's I2C device address, start operation */
	USBOTG_I2C_XCVR_DEVAD = OTG_TXCVR_DEV_WRITE_ADDR;

	return otg_i2c_wait_busy();
}
#endif


static void __init
fixup_mx21(struct machine_desc *desc, struct tag *tags,
	   char **cmdline, struct meminfo *mi)

{
#if 0
	mi->bank[mi->nr_banks].start = 0xc0000000;
	mi->bank[mi->nr_banks].size  = 0x04000000;
	mi->bank[mi->nr_banks].node  = PHYS_TO_NID(0xc0000000);
	mi->nr_banks += 1;
#endif
}


static struct map_desc imx21ads_io_desc[] __initdata = {
    /* virtual     physical    length      type */
    {IMX_CS0_VIRT, IMX_CS0_PHYS >> PAGE_SHIFT, IMX_CS0_SIZE, MT_DEVICE},
    {IMX_CS1_VIRT, IMX_CS1_PHYS >> PAGE_SHIFT, IMX_CS1_SIZE, MT_DEVICE},
};

#if defined(CONFIG_USB_IMX21_HCD)
static void imx21_hc_init(void)
{
	/* Enable the clocks to the USB OTG module */
	PCCR0 |= PCCR0_HCLK_USBOTG_EN | PCCR0_USBOTG_EN;

	/* Configure the GPIO */
	imx_gpio_mode(23 | GPIO_PORTB );   /* USB Host PWR */

	imx_gpio_mode(13 | GPIO_PORTC );   /* USB Host RXDP */
	imx_gpio_mode(12 | GPIO_PORTC );   /* USB Host RXDM */
	imx_gpio_mode(11 | GPIO_PORTC );   /* USB Host TXDP */
	imx_gpio_mode(10 | GPIO_PORTC );   /* USB Host TXDM */
	imx_gpio_mode( 9 | GPIO_PORTC );   /* USB Host OE */
	imx_gpio_mode( 8 | GPIO_PORTC | GPIO_IN | GPIO_GPIO | GPIO_PUEN); /* FS */
	imx_gpio_mode( 7 | GPIO_PORTC );   /* USB Host ON */
	imx_gpio_mode( 6 | GPIO_PORTC );   /* USB Host SCL */
	imx_gpio_mode( 5 | GPIO_PORTC );   /* USB Host SDA */

	/* Reset the USB OTG module */
	USBOTG_RST_CTRL = (USBOTG_RST_RSTCTRL |
	USBOTG_RST_RSTFC   |
	USBOTG_RST_RSTFSKE |
	USBOTG_RST_RSTRH   |
	USBOTG_RST_RSTHSIE |
	USBOTG_RST_RSTHC);

	/* Wait for reset to finish */
	while (USBOTG_RST_CTRL != 0) {
		schedule_timeout(1);
	}

	/* Enable clock to the host controller */
	USBOTG_CLK_CTRL = USBOTG_CLK_CTRL_HST | USBOTG_CLK_CTRL_MAIN;

	/*
	 *      * Configure the USBOTG module:
	 *           *   Host xcvr single ended TX, diff RX
	 *                *   USBOTG xcvr single ended TX, diff RX
	 *                     *   USBOTG in func mode
	 *                          */
	USBOTG_HWMODE = (USBOTG_HWMODE_OTGXCVR_TS_RD |
	USBOTG_HWMODE_HOSTXCVR_TS_RD |
	USBOTG_HWMODE_CRECFG_HOST);

	USBOTG_HNP_CSR = 0;

	USBOTG_I2C_SCLK_TO_SCK_HPER = 0xf0; /* Clock = 100KHz = 0xf0 */
	USBOTG_I2C_MASTER_INT_REG &= 0x0f;  /* disable interrupts */
	USBOTG_I2C_MASTER_INT_REG &= 0xf0;  /* clear interrupts */

	USBOTG_I2C_OP_CTRL_REG = 0x01;      /* Enable output, sw mode */

	otg_i2c_wait_busy();


	otg_i2c_reg_write(OTG_TXCVR_MODE_REG1_CLR, 0xFF);
	otg_i2c_reg_write(OTG_TXCVR_MODE_REG2_CLR, 0xFF);
	otg_i2c_reg_write(OTG_TXCVR_CTRL_REG1_SET, 0xC);
	otg_i2c_reg_write(OTG_TXCVR_CTRL_REG1_CLR, ~0xC);
	otg_i2c_reg_write(OTG_TXCVR_INT_FALSE_REG_CLR, 0xFF);
	otg_i2c_reg_write(OTG_TXCVR_INT_TRUE_REG_SET, ISP1301_ID_GROUNDED);
	otg_i2c_reg_write(OTG_TXCVR_INT_TRUE_REG_CLR, ~ISP1301_ID_GROUNDED);
	otg_i2c_reg_write(OTG_TXCVR_INT_FALSE_REG_SET, ISP1301_ID_GROUNDED);
	otg_i2c_reg_write(OTG_TXCVR_INT_FALSE_REG_CLR, ~ISP1301_ID_GROUNDED);
	otg_i2c_reg_write(OTG_TXCVR_INT_LAT_REG_CLR, 0xFF);

	/* Disable B device */
	otg_i2c_reg_write(OTG_TXCVR_CTRL_REG1_CLR, 0x1);
	otg_i2c_reg_write(OTG_TXCVR_CTRL_REG1_SET, 0x4);
	USBOTG_HNP_CSR &= ~(1 << 22);

	/* Enable A device */
	USBOTG_HNP_CSR |= (1 << 21);
	otg_i2c_reg_write(OTG_TXCVR_MODE_REG1_SET, 0x5); /* DAT_SE0 mode, full speed */
	otg_i2c_reg_write(OTG_TXCVR_CTRL_REG1_SET, 0x20);
}
#endif

static void __init imx21ads_map_io(void)
{
    imx21_map_io();
    iotable_init(imx21ads_io_desc, ARRAY_SIZE(imx21ads_io_desc));
}

static void __init imx21ads_init(void)
{
#if defined(CONFIG_FB_IMX)
	/* Configure I/O for LCD */
	GIUS(0) = 0;
	GPR(0) = 0;
	__REG16(MX2ADS_FPGA_VIRT) |= 1<<9;
     
	set_imx_fb_info(&imx21ads_fb_info);
#endif

#if defined(CONFIG_CIRRUS)
	//set_irq_type(MX2ADS_ETH_IRQ,IRQT_RISING);
#endif
	
	
#if defined(CONFIG_USB_IMX21_HCD)
	imx21_hc_init();
#endif

	platform_add_devices(devices, ARRAY_SIZE(devices));

}
MACHINE_START(MX2ADS, "Freescale IMX21ADS")
	.fixup		= fixup_mx21,
	.map_io         = imx21ads_map_io,
	.init_irq       = imx21_init_irq,
	.timer          = &imx_timer,
	.init_machine   = imx21ads_init,

MACHINE_END
