/**
*@addtogroup Keypad
*/
/**@{*/


/**
*@file kpp.h
*@brief Keypad driver header file
*
*  linux/drivers/input/keyboard/kpp.h
*/

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Copyright (C) 2003 Motorola Inc Ltd
 *
 */
#ifndef __KPP_INC_H_
#define __KPP_INC_H_


#define TRACE(fmt, args...)

#define MAX_NUM_DOMAINS 2

 //<<<<<< Macro for keypad device
 #define KPP_MX2_MASK			0x3f3f //for MX2, it is 6*6 key matrix
#define KPP_MX2_COL_NUM			6
#define KPP_MX2_ROW_NUM			6

#define kpp_row_enable(mask)	(KPCR|(mask))
#define kpp_col_enable(mask)	(KPCR|(mask<<8))

#define KPP_KPPEN_BIT_MASK		0x0400 //kpp clock gating enable
#define KPP_KRIE_BIT_MASK		0x0200 //kpp release interrupt enable
#define KPP_KDIE_BIT_MASK		0x0100 //kpp depress interrupt enable
#define KPP_KRSS_BIT_MASK		0x0008 //kpp release synchronizer set
#define KPP_KDSC_BIT_MASK		0x0004 //kpp depress synchronizer clear
#define KPP_KPKR_BIT_MASK		0x0002 //kpp key release
#define KPP_KPKD_BIT_MASK		0x0001 //kpp key depress

#define KPP_IRQ					21

 //<<<<<< structs
#define MAX_RING_SIZE			80
typedef struct {
	unsigned char key;
	int value;
}shared_data_t;
typedef struct {
	unsigned long rptr;
	unsigned long wptr;
	unsigned int counts;
	unsigned int connected;
	shared_data_t ring[MAX_RING_SIZE];

	u32 fb_ssa;
}shared_ring_t;

typedef enum {FD_SWITCH, NUM, ALPHA1, ALPHA2} e_key_type;
 //<<<<<< keycodes
//[col][row][type] 
// type : 0 - num, 1 - alpha1, 2 - alpha2
const unsigned char kpp_keycode[6][6][3] = {	
	[5][5][0]	 = KEY_SEMICOLON,
	[5][4][0]	 = KEY_TAB,
	[5][3][0]	 = KEY_DOWN,
	[5][2][0]	 = KEY_PAGEUP,
	[5][1][0]	 = KEY_PAGEDOWN,
	[5][0][0]	 = KEY_SLASH,

	[4][0][0]	 = KEY_CAPSLOCK,
	[4][1][0]	 = FD_SWITCH,
	[4][2][0]	 = ALPHA1,
	[4][3][0]	 = NUM,
	[4][4][0]	 = KEY_HOME,
	[4][5][0]	 = KEY_SPACE,
	
	[0][0][0]	 = KEY_MINUS,
	[0][0][1]	 = KEY_Y,		
	[0][0][2]	 = KEY_Z	,	
	[0][1][0]	 = KEY_SPACE,
	[0][2][0]	 = KEY_ENTER,
	[0][3][0]	 = KEY_BACKSPACE,
	[0][4][0]	 = KEY_BACKSPACE,
	[0][5][0]	 = KEY_ESC,
	
	[1][0][0]	 = KEY_DOT,
	[1][0][1]	 = KEY_W,
	[1][0][2]	 = KEY_X,	
	[1][1][0]	 = KEY_9,
	[1][1][1]	 = KEY_Q,
	[1][1][2]	 = KEY_R,	
	[1][2][0]	 = KEY_6,
	[1][2][1]	 = KEY_K,
	[1][2][2]	 = KEY_L,	
	[1][3][0]	 = KEY_3,
	[1][3][1]	 = KEY_E,
	[1][3][2]	 = KEY_F,	
	[1][4][0]	 = KEY_RIGHT,
	[1][5][0]	 = KEY_LEFTALT,
	
	[2][0][0]	 = KEY_0,
	[2][0][1]	 = KEY_U,
	[2][0][2]	 = KEY_V,	
	[2][1][0]	 = KEY_8,
	[2][1][1]	 = KEY_O,
	[2][1][2]	 = KEY_P,	
	[2][2][0]	 = KEY_5,
	[2][2][1]	 = KEY_I,
	[2][2][2]	 = KEY_J,	
	[2][3][0]	 = KEY_2,
	[2][3][1]	 = KEY_C,
	[2][3][2]	 = KEY_D,	
	[2][4][0]	 = KEY_ENTER,
	[2][5][0]	 = KEY_UP,
	
	[3][0][0]	 = KEY_SLASH,
	[3][0][1]	 = KEY_S,
	[3][0][2]	 = KEY_T,	
	[3][1][0]	 = KEY_7,
	[3][1][1]	 = KEY_M,
	[3][1][2]	 = KEY_N,	
	[3][2][0]	 = KEY_4,
	[3][2][1]	 = KEY_G,
	[3][2][2]	 = KEY_H,	
	[3][3][0]	 = KEY_1,
	[3][3][1]	 = KEY_A,
	[3][3][2]	 = KEY_B,	
	[3][4][0]	 = KEY_LEFT,
	[3][5][0]	 = KEY_TAB,
	
};


#define RESUME_POWER_ON 0
#define SUSPEND_POWER_DOWN 1
#define RESUME_ENABLE 2
#define SUSPEND_DISABLE 3

#endif

