#ifndef __DIGI_H_MX2_
#define __DIGI_H_MX2_

/**
 * @ingroup DIGI
 * @file touchscreen.h
 * @brief Header file for digi driver
 */

#define TPNL_IRQ 					8           //INT_GPIO
#define TPNL_INTR_MODE				SA_INTERRUPT|SA_SHIRQ
#define TPNL_PEN_UPVALUE			-999

#define SPI_TE_INT_BIT		0x00000001	
#define	SPI_TSHFE_INT_BIT	0x00000008
#define SPI_XCH_BIT			0x00000200	
#define SPI_RR_INT_BIT		0x00000010			
#define SPI_XCH_MASK		0xfffffdff
#define SPI_EN_BIT			0x00000400

#define EDGE_MIN_LIMIT  (100)
#define EDGE_MAX_LIMIT  (4000)

#define QT_IPAQ	

typedef struct {
#ifdef QT_IPAQ
	unsigned short pressure;
#else
	unsigned char pressure;
#endif
	unsigned short x;
	unsigned short y;
#ifdef QT_IPAQ
	unsigned short pad;
#endif
} ts_event_t;


#define  MAX_ID 	0x14

#ifdef QT_IPAQ
#define PENUP		0x0
#define PENDOWN		0xffff
#else
#define PENUP		0x0
#define PENDOWN		0xff
#endif

#endif

