/*
 * /drivers/xen/fbsetback/fbsetback-imx21.c
 *
 * Copyright (C) 2008 Samsung Electronics
 *          Dong-Hyuk lee  <dh5050.lee@samsung.com>
 *
 * Secure Xen on ARM architecture designed by Sang-bum Suh consists of
 * Xen on ARM and the associated access control.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public version 2 of License as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#include <asm/hardware.h>
#include <asm/arch/imx-regs.h>
#include <xen/xenbus.h>
#include "common.h"
#include <linux/delay.h>

/* codes below is for interdomain communication */
unsigned int foreground_dom = 0;

unsigned int fbset_backend;

extern u32 my_ssa;
extern u32 other_ssa;
extern u32 my_ssa_gw1;

extern int show_status_img_to_gw(int fg_dom);
extern void dom_destroy_cb(int domid);

irqreturn_t fbsetif_be_int(int irq, void *dev_id)
{
		return IRQ_HANDLED;
}

static int __init fbset_init(void)
{
      fbset_xenbus_init();
	 
	  fbset_backend = 0;  // Dom0(privileged domain) has backend
	  
	  return 0;
}

module_init(fbset_init);

static void fbset_exit(void)
{
	BUG();
}



unsigned int  switch_foreground_dom(int domid) 
{
	int changed=0;

	if (foreground_dom == domid){
		changed = 1;
		return changed;
	}

       if(domid == fbset_backend ) // if be-in-dom1
       {
           LCDC_SSA = my_ssa;
	   _reg_LCDC_LGWSAR = my_ssa_gw1;
	    show_status_img_to_gw(domid);
            HYPERVISOR_do_set_foreground_domain(domid);
	   foreground_dom = domid;	   
	   changed=1;

       }
       else
       {
       	fbsetif_t* i;
		fbsetif_ring_t* ring;

		list_for_each_entry(i,&frontfbsets,list)
		{
		   	if (i->domid == domid && i->status == CONNECTED)
	   		{
                         	printk("ready to change dom%d\n",domid);
				ring = (fbsetif_ring_t*)i->fbset_ring_area->addr;
				if(!(ring->fb_ssa)) return changed;
				if(!(ring->fb_ssa_gw1)) return changed;

				LCDC_SSA = ring->fb_ssa;
				_reg_LCDC_LGWSAR = ring->fb_ssa_gw1;
		               printk("ready to change dom%d, fb_ssa=0x%x\n",domid,ring->fb_ssa);

		 	     	show_status_img_to_gw(domid);
              		HYPERVISOR_do_set_foreground_domain(domid);
				foreground_dom = domid;
				changed=1;

	       	}
		}
	}
	return changed;
}

EXPORT_SYMBOL(foreground_dom);
EXPORT_SYMBOL(switch_foreground_dom);

module_exit(fbset_exit);

