/*
 * /drivers/xen/kppback/common.h
 *
 * Copyright (C) 2008 Samsung Electronics
 *          Cheol-Ryeon kim  <cr2104.kim@samsung.com>
 *          Dong-Hyuk lee  <dh5050.lee@samsung.com>
 *
 * Secure Xen on ARM architecture designed by Sang-bum Suh consists of
 * Xen on ARM and the associated access control.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public version 2 of License as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <xen/kppif.h>
#include <linux/interrupt.h>

int kppif_map(kppif_t *kppif, unsigned long shared_page, unsigned int evtchn);

void kpp_xenbus_init(void);

kppif_t *alloc_kppif(domid_t domid);

irqreturn_t kppif_be_int(int irq, void *dev_id);
