/*
 *  linux/include/asm-arm/arch-mx2ads/audmux.h
 *
 *  Hardware register address and field definitions for the
 *  AUDMUX module of the Freescale i.MX21 Applications Processor
 *
 *  Copyright (C) 2004 Metrowerks
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ASM_ARCH_AUDMUX_H
#define __ASM_ARCH_AUDMUX_H

/************************************************************************
 * Module: AUDMUX, Addr Range: 0x10016000 - 0x10016FFF, Size: 4 Kbyte
 ************************************************************************/
#define AUDMUX_BASE_ADDR      0x10016000           /* AUDMUX Base Address */
typedef volatile struct {
	unsigned int hpcr1;			/* Host Port Config Reg 1 */
	unsigned int hpcr2;         /* Host Port Config Reg 2 */
	unsigned int hpcr3;         /* Host Port Config Reg 3 */
	int pad0;
	unsigned int ppcr1;         /* Perif Port Config Reg 1 */
	unsigned int ppcr2;         /* Perif Port Config Reg 2 */
	int pad1;
	unsigned int ppcr3;         /* Perif Port Config Reg 3 */
} mx2ads_audmux_t;

extern mx2ads_audmux_t *mx2ads_audmux;

/* AUDMUX Host Port Configuration Register */
#define AUDMUX_HPCR_TFS_DIR	(1 << 31)         /* Xmit frame sync dir */
#define AUDMUX_HPCR_TCLK_DIR	(1 << 30)         /* Xmit clk dir */
#define AUDMUX_HPCR_TFCSEL(x)	(((x) & 0xF)<<26) /* Xmit frame sync/clk sel */
#define AUDMUX_HPCR_RFS_DIR	(1 << 25)         /* Rcv frame sync dir */
#define AUDMUX_HPCR_RCLK_DIR	(1 << 24)         /* Rcv clk dir */
#define AUDMUX_HPCR_RFCSEL(x)	(((x) & 0xF)<<20) /* Rcv frame sync/clk sel */
#define AUDMUX_HPCR_RXDSEL(x)	(((x) & 0x7)<<13) /* Rcv data sel */
#define AUDMUX_HPCR_SYN		(1 << 12)         /* Sync/async sel */
#define AUDMUX_HPCR_TXRXEN	(1 << 10)         /* Xmit/rcv switch enable */
#define AUDMUX_HPCR_INMEN	(1 <<  8)         /* Internal net mode enable */
#define AUDMUX_HPCR_INMMASK(x)	((x) & 0xFF)      /* Internal net mode mask */

/* AUDMUX Peripheral Port Configuration Register */
#define AUDMUX_PPCR_TFS_DIR	(1 << 31)         /* Xmit frame sync dir */
#define AUDMUX_PPCR_TCLK_DIR	(1 << 30)         /* Xmit clk dir */
#define AUDMUX_PPCR_TFCSEL(x)	(((x) & 0xF)<<26) /* Xmit frame sync/clk sel */
#define AUDMUX_PPCR_RFS_DIR	(1 << 25)         /* Rcv frame sync dir */
#define AUDMUX_PPCR_RCLK_DIR	(1 << 24)         /* Rcv clk dir */
#define AUDMUX_PPCR_RFCSEL(x)	(((x) & 0xF)<<20) /* Rcv frame sync/clk sel */
#define AUDMUX_PPCR_RXDSEL(x)	(((x) & 0x7)<<13) /* Rcv data sel */
#define AUDMUX_PPCR_SYN		(1 << 12)         /* Sync/async sel */
#define AUDMUX_PPCR_TXRXEN	(1 << 10)         /* Xmit/rcv switch enable */

#endif  /* __ASM_ARCH_AUDMUX_H */
