/*
 *  linux/include/asm-arm/arch-mx2ads/clk.h
 *
 *  Hardware register address and field definitions for the
 *  CLK module of the Freescale i.MX21 Applications Processor
 *
 *  Copyright (C) 2004 Metrowerks
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ASM_ARCH_CLK_H
#define __ASM_ARCH_CLK_H

#include <asm/arch/hardware.h>

#define OSC32_CRYSTAL_FREQ   32768

/************************************************************************
 * Module: CLK, Addr Range: 0x10027000 - 0x10027FFF, Size: 4 Kbyte
 ************************************************************************/
#define CLK_BASE_ADDR      0x10027000           /* CLK Base Address */
typedef volatile struct {
	unsigned int cscr;			/* Clock Source Control Register */
	unsigned int mpctl0;        /* MPLL Control Register 0 */
	unsigned int mpctl1;        /* MPLL Control Register 1 */
	unsigned int spctl0;        /* SPLL Control Register 0 */
	unsigned int spctl1;        /* SPLL Control Register 1 */
	unsigned int osc26mctl;     /* Oscillator 26M Register */
#ifdef CONFIG_MX2_TO11
	unsigned int pcdr;			/* Peripheral Clock Divider Reg */
	unsigned int pccr0;         /* Peripheral Clock Control Reg 0 */
	unsigned int pccr1;         /* Peripheral Clock Control Reg 1 */
#else
	unsigned int pcdr0;			/* Peripheral Clock Divider Reg 0 */
	unsigned int pcdr1;         /* Peripheral Clock Divider Reg 1 */
	unsigned int pccr0;         /* Peripheral Clock Control Reg 0 */
	unsigned int pccr1;         /* Peripheral Clock Control Reg 1 */
	unsigned int ccsr;          /* Clock Control Status Register */
	unsigned int pmctl;         /* PMOS Control Register */
	unsigned int pmcount;       /* PMOS Counter Register */
	unsigned int wkgdctl;       /* Wakeup Guard Mode Control Register */
#endif
} mx2ads_clk_t;

extern mx2ads_clk_t *mx2ads_clk;


/* CLK_CSCR - Clock Source Control Register - fields */
#ifdef CONFIG_MX2_TO11
#define CLK_CSCR_CLKO_SEL(n)  (((n) & 0x07) << 29) /* Clock signal source for the CLKO pin. */
#define CLK_CSCR_PRESC_POS     14                  /* field position */
#define CLK_CSCR_PRESC_MASK    0x03                /* field mask */
#else
#define CLK_CSCR_PRESC_POS     29                  /* field position */
#define CLK_CSCR_PRESC_MASK    0x07                /* field mask */
#endif
#define CLK_CSCR_PRESC(x)      (((x) & CLK_CSCR_PRESC_MASK) << CLK_CSCR_PRESC_POS) /* Prescaler for MPU PLL clock. */
#define CLK_CSCR_USB_POS       26                  /* field position */
#define CLK_CSCR_USB_MASK      0x7                 /* field mask */
#define CLK_CSCR_USB_DIV(x)    (((x) & 0x7) << CLK_CSCR_USB_POS) /* USB Clock Divider */
#define CLK_CSCR_SD_CNT(x)     (((x) & 0x3) << 24) /* Shut-Down Control count */
#define CLK_CSCR_SPLL_RESTART  (1 << 22)           /* SPLL Restart */
#define CLK_CSCR_MPLL_RESTART  (1 << 21)           /* MPLL Restart */
#define CLK_CSCR_SSI2_SEL      (1 << 20)           /* SSI2 Baud Source Select */
#define CLK_CSCR_SSI1_SEL      (1 << 19)           /* SSI1 Baud Source Select */
#define CLK_CSCR_FIR_SEL       (1 << 18)           /* FIR and MIR Select */
#define CLK_CSCR_SP_SEL        (1 << 17)           /* SPLL Select */
#define CLK_CSCR_MCU_SEL       (1 << 16)           /* MPLL Select */
#define CLK_CSCR_BCLKDIV_POS   10                  /* field position */
#define CLK_CSCR_BCLKDIV_MASK  0xf                 /* field mask */
#define CLK_CSCR_BCLKDIV(x)    (((x) & CLK_CSCR_BCLKDIV_MASK) << CLK_CSCR_BCLKDIV_POS) /* System Bus Clock Divider */
#define CLK_CSCR_IPDIV_POS     9
#define CLK_CSCR_IPDIV_MASK    1
#define CLK_CSCR_IPDIV(x)      (((x) & CLK_CSCR_IPDIV_MASK ) << CLK_CSCR_IPDIV_POS)    /* Peripheral Clock Divider */
#define CLK_CSCR_OSC26M_DIV1P5 (1 <<  4)           /* Oscillator 26M Divide - 1 or 1.5 */
#define CLK_CSCR_OSC26M_EN     (1 <<  3)           /* 26 MHz Oscillator Enable */
#define CLK_CSCR_FPM_EN        (1 <<  2)           /* Frequency Premultiplier Enable */
#define CLK_CSCR_SPEN          (1 <<  1)           /* Serial Peripheral PLL Enable */
#define CLK_CSCR_MPEN          (1 <<  0)           /* MPLL Enable */

#ifdef CONFIG_MX2_TO11
/* CLKO pin selects to be used with CLK_CSCR_CLKO_SEL(n) */
#define CLK_CSCR_CLKO_HCLK	   0       /* HCLK  		 */
#define CLK_CSCR_CLKO_SPLLREF  1       /* SPLL reference */
#define CLK_CSCR_CLKO_CLK48M   2       /* CLK48M		 */
#define CLK_CSCR_CLKO_CLK26M   3       /* CLK26M		 */
#define CLK_CSCR_CLKO_FPMCLK   4       /* FPMCLK		 */
#define CLK_CSCR_CLKO_FCLK	   5       /* FCLK  		 */
#define CLK_CSCR_CLKO_CLK32	   6       /* CLK32 		 */
#define CLK_CSCR_CLKO_IPGCLK   7       /* IPG_CLK		 */
#endif

/* CLK_MPCTL0 - MCU & System PLL Control Register 0 - fields */
#define CLK_MPCTL0_CPLM    (1 << 31)             /* Phase Lock Mode */

#define CLK_MPCTL0_PD_POS   26                   /* field position */
#define CLK_MPCTL0_PD_MASK  0x0f                 /* field mask */
#define CLK_MPCTL0_PD(x)   (((x) & CLK_MPCTL0_PD_MASK) << CLK_MPCTL0_PD_POS)   /* Predivider Factor */

#define CLK_MPCTL0_MFD_POS  16                   /* field position */
#define CLK_MPCTL0_MFD_MASK 0x3ff                /* field mask */
#define CLK_MPCTL0_MFD(x)  (((x) & CLK_MPCTL0_MFD_MASK) << CLK_MPCTL0_MFD_POS) /* Multiplication Factor (Denominator Part) */

#define CLK_MPCTL0_MFI_POS  10                   /* field position */
#define CLK_MPCTL0_MFI_MASK 0x0f                 /* field mask */
#define CLK_MPCTL0_MFI(x)  (((x) & CLK_MPCTL0_MFI_MASK) << CLK_MPCTL0_MFI_POS) /* Multiplication Factor (Integer) */

#define CLK_MPCTL0_MFN_POS  0                    /* field position */
#define CLK_MPCTL0_MFN_MASK 0x3ff                /* field mask */
#define CLK_MPCTL0_MFN(x)  (((x) & CLK_MPCTL0_MFN_MASK) << CLK_MPCTL0_MFN_POS) /* Multiplication Factor (Numerator) */


/* CLK_MPCTL1 - MCU & System PLL Control Register 1 - fields */
#define CLK_MPCTL1_LF      (1 << 15)              /* Lock Flag */
#define CLK_MPCTL1_BRMO    (1 <<  6)              /* BRM Order */

/* CLK_SPCTL0 - Serial Peripheral PLL Control Register 0 - fields */
#define CLK_SPCTL0_CPLM    (1 << 31)             /* Phase Lock Mode */

#define CLK_SPCTL0_PD_POS   26                   /* field position */
#define CLK_SPCTL0_PD_MASK  0x0f                 /* field mask */
#define CLK_SPCTL0_PD(x)   (((x) & CLK_SPCTL0_PD_MASK) << CLK_SPCTL0_PD_POS)   /* Predivider Factor */

#define CLK_SPCTL0_MFD_POS  16                   /* field position */
#define CLK_SPCTL0_MFD_MASK 0x3ff                /* field mask */
#define CLK_SPCTL0_MFD(x)  (((x) & CLK_SPCTL0_MFD_MASK) << CLK_SPCTL0_MFD_POS) /* Multiplication Factor (Denominator Part) */

#define CLK_SPCTL0_MFI_POS  10                   /* field position */
#define CLK_SPCTL0_MFI_MASK 0x0f                 /* field mask */
#define CLK_SPCTL0_MFI(x)  (((x) & CLK_SPCTL0_MFI_MASK) << CLK_SPCTL0_MFI_POS) /* Multiplication Factor (Integer) */

#define CLK_SPCTL0_MFN_POS  0                    /* field position */
#define CLK_SPCTL0_MFN_MASK 0x3ff                /* field mask */
#define CLK_SPCTL0_MFN(x)  (((x) & CLK_SPCTL0_MFN_MASK) << CLK_SPCTL0_MFN_POS) /* Multiplication Factor (Numerator) */

/* CLK_SPCTL1 - Serial Peripheral PLL Control Register 1 - fields */
#define CLK_SPCTL1_LF      (1 << 15)              /* Lock Flag */
#define CLK_SPCTL1_BRMO    (1 <<  6)              /* BRM Order Bit */

/* CLK_OSC26MCTL - Oscillator 26M Control Register - fields */
#define CLK_OSC26MCTL_PEAK(x) (((x) & 0x3) << 16)  /* OSC26M_PEAK */
#define CLK_OSC26MCTL_AGC(x)  (((x) & 0x3F) << 8)  /* Automatic Gain Control */

#ifdef CONFIG_MX2_TO11
/* CLK_PCDR (Peripheral Clock Divider Register) field definitions */
#define CLK_PCDR_SSI2DIV(n)     (((n) & 0x3f) << 26) /* SSI2 Baud Clock Divider */
#define CLK_PCDR_PERDIV2_POS    22                   /* field position */
#define CLK_PCDR_PERDIV2_MASK   0x0f                 /* field mask */
#define CLK_PCDR_PERDIV2(n)     (((n) & 0x0f) << 22) /* Peripheral Clock Divider 2 */
#define CLK_PCDR_SSI1DIV(n)     (((n) & 0x3f) << 16) /* SSI1 Baud Clock Divider */
#define CLK_PCDR_NFCDIV(n)      (((n) & 0x0f) << 12) /* Nand Flash Controller Clock Divider */
#define CLK_PCDR_PERDIV1_POS    8                    /* field position */
#define CLK_PCDR_PERDIV1_MASK   0x0f                 /* field mask */
#define CLK_PCDR_PERDIV1(n)     (((n) & 0x0f) <<  8) /* Peripheral Cock Divider 1 */
#define CLK_PCDR_CLKO_48DIV(n)  (((n) & 0x07) <<  5) /* Clock Out 48M Clock Divider 1 */
#define CLK_PCDR_FIRI_MIRDIV(n) (((n) & 0x1f) <<  0) /* FIRI Divider */
#else
/* CLK_PCDR0 - Peripheral Clock Divider Register 0 - fields */
#define CLK_PCDR0_SSI2DIV(x)     (((x) & 0x3F) << 26) /* SSI2 Baud Clock Divider */
#define CLK_PCDR0_SSI1DIV(x)     (((x) & 0x3F) << 16) /* SSI1 Baud Clock Divider */
#define CLK_PCDR0_NFCDIV(x)      (((x) & 0xF)  << 12) /* Nand Flash Controller Clock Divider */
#define CLK_PCDR0_CLKO_48MDIV(x) (((x) & 0x7)  <<  5) /* Clock Out 48M Clock Divider 1 */
#define CLK_PCDR0_FIRI_DIV(x)    (((x) & 0x1F) <<  0) /* FIRI Divider */
#endif

/* CLK_PCDR1 - Peripheral Clock Divider Register 1 - fields */
#define CLK_PCDR1_PERDIV4_POS  24                   /* field position */
#define CLK_PCDR1_PERDIV4_MASK 0x3f                 /* field mask */
#define CLK_PCDR1_PERDIV3_POS  16                   /* field position */
#define CLK_PCDR1_PERDIV3_MASK 0x3f                 /* field mask */
#define CLK_PCDR1_PERDIV2_POS  8                    /* field position */
#define CLK_PCDR1_PERDIV2_MASK 0x3f                 /* field mask */
#define CLK_PCDR1_PERDIV1_POS  0                    /* field position */
#define CLK_PCDR1_PERDIV1_MASK 0x3f                 /* field mask */
#define CLK_PCDR1_PERDIV4(x)   (((x) & CLK_PCDR1_PERDIV4_MASK) << CLK_PCDR1_PERDIV4_POS) /* Peripheral Clock Div 4 */
#define CLK_PCDR1_PERDIV3(x)   (((x) & CLK_PCDR1_PERDIV3_MASK) << CLK_PCDR1_PERDIV3_POS) /* Peripheral Clock Div 3 */
#define CLK_PCDR1_PERDIV2(x)   (((x) & CLK_PCDR1_PERDIV2_MASK) << CLK_PCDR1_PERDIV2_POS) /* Peripheral Clock Div 2 */
#define CLK_PCDR1_PERDIV1(x)   (((x) & CLK_PCDR1_PERDIV1_MASK) << CLK_PCDR1_PERDIV1_POS) /* Peripheral Clock Div 1 */


/* CLK_PCCR0 - Peripheral Clock Control Register 0 - fields */
#define CLK_PCCR0_HCLK_CSI_EN    (1 << 31)   /* CMOS Sensor Interface Clock Enable */
#define CLK_PCCR0_HCLK_DMA_EN    (1 << 30)   /* DMA Clock Enable */
#define CLK_PCCR0_HCLK_BROM_EN   (1 << 28)   /* BROM Clock Enable */
#define CLK_PCCR0_HCLK_EMMA_EN   (1 << 27)   /* EMMA Clock Enable */
#define CLK_PCCR0_HCLK_LCDC_EN   (1 << 26)   /* LCDC Clock Enable */
#define CLK_PCCR0_HCLK_SLCDC_EN  (1 << 25)   /* SLCDC Clock Enable */
#define CLK_PCCR0_HCLK_USBOTG_EN (1 << 24)   /* USB OTG Clock Enable */
#define CLK_PCCR0_HCLK_BMI_EN    (1 << 23)   /* BMI Clock Enable */
#define CLK_PCCR0_PERCLK4_EN     (1 << 22)   /* PERCLK4 Clock Enable */
#define CLK_PCCR0_SLCDC_EN       (1 << 21)   /* SLCDC Clock Enable */
#define CLK_PCCR0_FIRI_BUAD_EN   (1 << 20)   /* FIRI Baud Clock Enable */
#define CLK_PCCR0_NFC_EN         (1 << 19)   /* Nand Flash Controller Clock Enable */
#ifdef CONFIG_MX2_TO11
#define CLK_PCCR0_LCDC_PIXCLK_EN (1 << 18)   /* LCDC Pixel Clock Enable */
#else
#define CLK_PCCR0_PERCLK3_EN     (1 << 18)   /* PERCLK3 Clock Enable */
#endif
#define CLK_PCCR0_SSI1_BAUD_EN   (1 << 17)   /* SSI 1 Baud Clock Enable */
#define CLK_PCCR0_SSI2_BAUD_EN   (1 << 16)   /* SSI 2 Baud Clock Enable */
#define CLK_PCCR0_EMMA_EN        (1 << 15)   /* EMMA Clock Enable */
#define CLK_PCCR0_USBOTG_EN      (1 << 14)   /* USB OTG Clock Enable */
#define CLK_PCCR0_DMA_EN         (1 << 13)   /* DMA Clock Enable */
#define CLK_PCCR0_I2C_EN         (1 << 12)   /* I2C Clock Enable */
#define CLK_PCCR0_GPIO_EN        (1 << 11)   /* GPIO Clock Enable */
#define CLK_PCCR0_SDHC2_EN       (1 << 10)   /* SDHC2 Clock Enable */
#define CLK_PCCR0_SDHC1_EN       (1 <<  9)   /* SDHC1 Clock Enable */
#define CLK_PCCR0_FIRI_EN        (1 <<  8)   /* FIRI Clock Enable */
#define CLK_PCCR0_SSI2_EN        (1 <<  7)   /* SSI2 Clock Enable */
#define CLK_PCCR0_SSI1_EN        (1 <<  6)   /* SSI1 Clock Enable */
#define CLK_PCCR0_CSPI2_EN       (1 <<  5)   /* CSPI2 Clock Enable */
#define CLK_PCCR0_CSPI1_EN       (1 <<  4)   /* CSPI1 Clock Enable */
#define CLK_PCCR0_UART4_EN       (1 <<  3)   /* UART4 Clock Enable */
#define CLK_PCCR0_UART3_EN       (1 <<  2)   /* UART3 Clock Enable */
#define CLK_PCCR0_UART2_EN       (1 <<  1)   /* UART2 Clock Enable */
#define CLK_PCCR0_UART1_EN       (1 <<  0)   /* UART1 Clock Enable */

/* CLK_PCCR1 - Peripheral Clock Control Register 1 - fields */
#define CLK_PCCR1_OWIRE_EN       (1 << 31)   /* ONE WIRE  Clock Enable */
#define CLK_PCCR1_KPP_EN         (1 << 30)   /* Keypad Clock Enable */
#define CLK_PCCR1_RTC_EN         (1 << 29)   /* RTC  Clock Enable */
#define CLK_PCCR1_PWM_EN         (1 << 28)   /* PWM  Clock Enable */
#define CLK_PCCR1_GPT3_EN        (1 << 27)   /* GPT3  Clock Enable */
#define CLK_PCCR1_GPT2_EN        (1 << 26)   /* GPT2  Clock Enable */
#define CLK_PCCR1_GPT1_EN        (1 << 25)   /* GPT1  Clock Enable */
#define CLK_PCCR1_WDT_EN         (1 << 24)   /* WDT Clock Enable */
#define CLK_PCCR1_CSPI3_EN       (1 << 23)   /* CSPI3 Clock Enable */
#define CLK_PCCR1_RTIC_EN        (1 << 22)   /* RTIC Clock Enable */
#define CLK_PCCR1_RNGA_EN        (1 << 21)   /* RNGA Clock Enable */

/* CLK_CCSR - Clock Control Status Register - fields */
#define CLK_CCSR_32K_SR      (1 << 15)           /* 32K clock Status Register */
#define CLK_CCSR_CLKO_SEL(x) (((x) & 0x1F) << 0) /* CLKO Select */

/* CLKO pin selects to be used with CLK_CCSR_CLKO_SEL(x) */
#define CLK_CCSR_CLKO_CLK32           0
#define CLK_CCSR_CLKO_PREMCLK         1
#define CLK_CCSR_CLKO_CLK26M          2
#define CLK_CCSR_CLKO_MPLL_REF_CLK    3
#define CLK_CCSR_CLKO_SPLL_REF_CLK    4
#define CLK_CCSR_CLKO_MPLL_CLK        5
#define CLK_CCSR_CLKO_SPLL_CLK        6
#define CLK_CCSR_CLKO_FCLK            7
#define CLK_CCSR_CLKO_HCLK            8
#define CLK_CCSR_CLKO_IPG_CLK         9
#define CLK_CCSR_CLKO_PERCLK1        10
#define CLK_CCSR_CLKO_PERCLK2        11
#define CLK_CCSR_CLKO_PERCLK3        12
#define CLK_CCSR_CLKO_PERCLK4        13
#define CLK_CCSR_CLKO_SSI1           14
#define CLK_CCSR_CLKO_SSI2           15
#define CLK_CCSR_CLKO_NFC            16
#define CLK_CCSR_CLKO_FIRI           17
#define CLK_CCSR_CLKO_CLK48M_ALWAYS  18
#define CLK_CCSR_CLKO_CLK32K_ALWAYS  19
#define CLK_CCSR_CLKO_CLK48M         20
#define CLK_CCSR_CLKO_CLK48DIV_CLKO  21

/* CLK_WKGDCTL - Wakeup Guard Mode Control Register - fields */
#define CLK_WKGDCTL_WKGD_EN   (1 << 0)  /* Wakeup Guard Mode Enable (Write-once-only) */

#endif  /* __ASM_ARCH_CLK_H */
