/*
 *  linux/include/asm-arm/arch-mx2ads/gpio.h
 *
 *  Hardware register address and field definitions for the
 *  GPIO module of the Freescale i.MX21 Applications Processor
 *
 *  Copyright (C) 2004 Metrowerks
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifndef __ASM_ARCH_GPIO_H
#define __ASM_ARCH_GPIO_H

#include <asm/arch/hardware.h>

/************************************************************************
 * Module: GPIO, Addr Range: 0x10015000 - 0x10015FFF, Size: 4 Kbyte
 ************************************************************************/
#define GPIO_BASE_ADDR        0x10015000           /* GPIO Base Address */
enum {
	PORT_A = 0,
	PORT_B,
	PORT_C,
	PORT_D,
	PORT_E,
	PORT_F,
	PORT_MAX
};

typedef volatile struct {
	unsigned int ddir;      /* Data Direction Register */
	unsigned int ocr[2];    /* Output Configuration Register 1 & 2 (OCR1/OCR2) */
	unsigned int iconf_a1;  /* Input Configuration Register A1 (ICONFA1) */
	unsigned int iconf_a2;  /* Input Configuration Register A2 (ICONFA2) */
	unsigned int iconf_b1;  /* Input Configuration Register B1 (ICONFB1) */
	unsigned int iconf_b2;  /* Input Configuration Register B2 (ICONFB2) */
	unsigned int dr;        /* Data Register */
	unsigned int gius;      /* GPIO In Use Register */
	unsigned int ssr;       /* Sample Status Register */
	unsigned int icr[2];    /* Interrupt Configuration Register 1 & 2 (ICR1/ICR2) */
	unsigned int imr;       /* Interrupt Mask Register */
	unsigned int isr;       /* Interrupt Status Register */
	unsigned int gpr;       /* General Purpose Register */
	unsigned int swr;       /* Software Reset Register */
	unsigned int puen;      /* Pull_up Enable Register */
	int pad[64-17];
} mx2ads_gpio_port_t;

typedef volatile struct {
	mx2ads_gpio_port_t port[PORT_MAX];
	unsigned int pmask;			/* GPIO Port Interrupt Mask */
} mx2ads_gpio_t;

extern mx2ads_gpio_t *mx2ads_gpio;

/* Macros that define 2-bit configuration fields
 * to be used with several of the port configuration registers */
#define GPIO_PIN_00_CONF(n) (((n) & 0x3) <<  0) /* pin configuation */
#define GPIO_PIN_01_CONF(n) (((n) & 0x3) <<  2) /* pin configuation */
#define GPIO_PIN_02_CONF(n) (((n) & 0x3) <<  4) /* pin configuation */
#define GPIO_PIN_03_CONF(n) (((n) & 0x3) <<  6) /* pin configuation */
#define GPIO_PIN_04_CONF(n) (((n) & 0x3) <<  8) /* pin configuation */
#define GPIO_PIN_05_CONF(n) (((n) & 0x3) << 10) /* pin configuation */
#define GPIO_PIN_06_CONF(n) (((n) & 0x3) << 12) /* pin configuation */
#define GPIO_PIN_07_CONF(n) (((n) & 0x3) << 14) /* pin configuation */
#define GPIO_PIN_08_CONF(n) (((n) & 0x3) << 16) /* pin configuation */
#define GPIO_PIN_09_CONF(n) (((n) & 0x3) << 18) /* pin configuation */
#define GPIO_PIN_10_CONF(n) (((n) & 0x3) << 20) /* pin configuation */
#define GPIO_PIN_11_CONF(n) (((n) & 0x3) << 22) /* pin configuation */
#define GPIO_PIN_12_CONF(n) (((n) & 0x3) << 24) /* pin configuation */
#define GPIO_PIN_13_CONF(n) (((n) & 0x3) << 26) /* pin configuation */
#define GPIO_PIN_14_CONF(n) (((n) & 0x3) << 28) /* pin configuation */
#define GPIO_PIN_15_CONF(n) (((n) & 0x3) << 30) /* pin configuation */
#define GPIO_PIN_16_CONF(n) (((n) & 0x3) <<  0) /* pin configuation */
#define GPIO_PIN_17_CONF(n) (((n) & 0x3) <<  2) /* pin configuation */
#define GPIO_PIN_18_CONF(n) (((n) & 0x3) <<  4) /* pin configuation */
#define GPIO_PIN_19_CONF(n) (((n) & 0x3) <<  6) /* pin configuation */
#define GPIO_PIN_20_CONF(n) (((n) & 0x3) <<  8) /* pin configuation */
#define GPIO_PIN_21_CONF(n) (((n) & 0x3) << 10) /* pin configuation */
#define GPIO_PIN_22_CONF(n) (((n) & 0x3) << 12) /* pin configuation */
#define GPIO_PIN_23_CONF(n) (((n) & 0x3) << 14) /* pin configuation */
#define GPIO_PIN_24_CONF(n) (((n) & 0x3) << 16) /* pin configuation */
#define GPIO_PIN_25_CONF(n) (((n) & 0x3) << 18) /* pin configuation */
#define GPIO_PIN_26_CONF(n) (((n) & 0x3) << 20) /* pin configuation */
#define GPIO_PIN_27_CONF(n) (((n) & 0x3) << 22) /* pin configuation */
#define GPIO_PIN_28_CONF(n) (((n) & 0x3) << 24) /* pin configuation */
#define GPIO_PIN_29_CONF(n) (((n) & 0x3) << 26) /* pin configuation */
#define GPIO_PIN_30_CONF(n) (((n) & 0x3) << 28) /* pin configuation */
#define GPIO_PIN_31_CONF(n) (((n) & 0x3) << 30) /* pin configuation */

/* GPIO_SWR ports A-F  - Software Reset Register - fields */
#define GPIO_SWR		    (1 <<  0)    /* Software Port Reset */

/* GPIO_PMASK - Port Interrupt Mask Register - fields */
#define GPIO_PMASK_PTF      (1 <<  5)   /* Port F interrupt mask */
#define GPIO_PMASK_PTE      (1 <<  4)   /* Port E interrupt mask */
#define GPIO_PMASK_PTD      (1 <<  3)   /* Port D interrupt mask */
#define GPIO_PMASK_PTC      (1 <<  2)   /* Port C interrupt mask */
#define GPIO_PMASK_PTB      (1 <<  1)   /* Port B interrupt mask */
#define GPIO_PMASK_PTA      (1 <<  0)   /* Port A interrupt mask */

#endif  /* __ASM_ARCH_GPIO_H */
